% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaSandwich-methods-r-sq-beta-sandwich.R
\name{vcov.rsqbetasandwich}
\alias{vcov.rsqbetasandwich}
\title{Sampling Covariance Matrix of
Multiple Correlation Coefficients
(R-Squared and Adjusted R-Squared)}
\usage{
\method{vcov}{rsqbetasandwich}(object, ...)
}
\arguments{
\item{object}{Object of class \code{rsqbetasandwich}.}

\item{...}{additional arguments.}
}
\value{
Returns a matrix of the
variance-covariance matrix
of multiple correlation coefficients
(R-squared and adjusted R-squared).
}
\description{
Sampling Covariance Matrix of
Multiple Correlation Coefficients
(R-Squared and Adjusted R-Squared)
}
\examples{
object <- lm(QUALITY ~ NARTIC + PCTGRT + PCTSUPP, data = nas1982)
std <- BetaHC(object)
rsq <- RSqBetaSandwich(std)
vcov(rsq)
}
\author{
Ivan Jacob Agaloos Pesigan
}
\keyword{methods}
