

#' breast cancer data set
#'
#' @name gravier
#'
#' @description Gravier et al. (2010) have considered small, invasive ductal carcinomas
#' without axillary lymph node involvement (T1T2N0) to predict metastasis of
#' small node-negative breast carcinoma. Using comparative genomic
#' hybridization arrays, they examined 168 patients over a five-year period.
#' The 111 patients with no event after diagnosis were labelled good, and the
#' 57 patients with early metastasis were labelled poor.
#'
#'
#' @format A list containing the design matrix X and response matrix y
#' @references Eleonore Gravier., Gaelle Pierron., and Anne Vincent-Salomon.
#' (2010). A prognostic DNA signature for T1T2 node-negative breast cancer
#' patients.
#' @keywords datasets
#' @return
#' No return value
#' @source \url{https://github.com/ramhiser}
NULL





#' Factors associated with prostate specific antigen
#'
#' @name prostate
#'
#' @description Data from a study by by Stamey et al. (1989) to examine the association
#' between prostate specific antigen (PSA) and several clinical measures that
#' are potentially associated with PSA in men who were about to receive a
#' radical prostatectomy.  The variables are as follows:
#'
#' \itemize{ \item lcavol: Log cancer volume \item lweight: Log prostate weight
#' \item age: The man's age \item lbph: Log of the amount of benign hyperplasia
#' \item svi: Seminal vesicle invasion; 1=Yes, 0=No \item lcp: Log of capsular
#' penetration \item gleason: Gleason score \item pgg45: Percent of Gleason
#' scores 4 or 5 \item lpsa: Log PSA }
#'
#'
#' @format A data frame with 97 observations on 9 variables
#' @references Stamey, T., Kabalin, J., McNeal, J., Johnstone, I., Freiha, F.,
#' Redwine, E. and Yang, N. (1989). Prostate specific antigen in the diagnosis
#' and treatment of adenocarcinoma of the prostate II. Radical prostatectomy
#' treated patients, Journal of Urology 16: 1076-1083.
#' @keywords datasets
#' @return
#' No return value
NULL





#' Risk factors associated with heart disease
#' @name SAheart
#'
#' @description Data from a subset of the Coronary Risk-Factor Study baseline survey,
#' carried out in rural South Africa.
#'
#' @format The variables are as follows:
#' \itemize{
#' \item sbp: Systolic blood pressure \item tobacco: Cumulative tobacco
#' consumption, in kg \item ldl: Low-density lipoprotein cholesterol \item
#' adiposity: Adipose tissue concentration \item famhist: Family history of
#' heart disease (1=Present, 0=Absent) \item typea: Score on test designed to
#' measure type-A behavior \item obesity: Obesity \item alcohol: Current
#' consumption of alcohol \item age: Age of subject \item chd: Coronary heart
#' disease at baseline; 1=Yes 0=No}
#'
#'
#' @format A data frame with 462 observations on 10 variables
#' @references Rousseauw, J., du Plessis, J., Benade, A., Jordaan, P., Kotze,
#' J. and Ferreira, J. (1983).  Coronary risk factor screening in three rural
#' communities. South African Medical Journal 64: 430-436.
#' @keywords datasets
#' @return
#' No return value
NULL





