% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sqrt_x.R
\name{sqrt_x}
\alias{sqrt_x}
\alias{predict.sqrt_x}
\alias{print.sqrt_x}
\title{sqrt(x + a) Normalization}
\usage{
sqrt_x(x, a = NULL, standardize = TRUE)

\method{predict}{sqrt_x}(object, newdata = NULL, inverse = FALSE, ...)

\method{print}{sqrt_x}(x, ...)
}
\arguments{
\item{x}{A vector to normalize with with x}

\item{a}{The constant to add to x (defaults to max(0, -min(x)))}

\item{standardize}{If TRUE, the transformed values are also centered and
scaled, such that the transformation attempts a standard normal}

\item{object}{an object of class 'sqrt_x'}

\item{newdata}{a vector of data to be (potentially reverse) transformed}

\item{inverse}{if TRUE, performs reverse transformation}

\item{...}{additional arguments}
}
\value{
A list of class \code{sqrt_x} with elements \item{x.t}{transformed
  original data} 
  \item{x}{original data} 
  \item{mean}{mean after transformation but prior to standardization} 
  \item{sd}{sd after transformation but prior to standardization} 
  \item{n}{number of nonmissing observations} 
  \item{norm_stat}{Pearson's P / degrees of freedom} 
  \item{standardize}{was the transformation standardized}

  The \code{predict} function returns the numeric value of the transformation
  performed on new data, and allows for the inverse transformation as well.
}
\description{
Perform a sqrt (x+a) normalization transformation
}
\details{
\code{sqrt_x} performs a simple square-root transformation in the
  context of bestNormalize, such that it creates a transformation that can be
  estimated and applied to new data via the \code{predict} function. The
  parameter a is essentially estimated by the training set by default
  (estimated as the minimum possible), while the base
  must be specified beforehand.
}
\examples{
x <- rgamma(100, 1, 1)

sqrt_x_obj <- sqrt_x(x)
sqrt_x_obj
p <- predict(sqrt_x_obj)
x2 <- predict(sqrt_x_obj, newdata = p, inverse = TRUE)

all.equal(x2, x)

}
