% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/around.R
\name{around}
\alias{around}
\title{View values around an index}
\usage{
around(x, i, n1 = 2, n2 = n1, convert = is.logical(i))
}
\arguments{
\item{x}{Data.frame}

\item{i}{Index (logical or integers)}

\item{n1}{Number of elements shown before each i. DEFAULT: 2}

\item{n2}{Number of elements shown after each i. DEFAULT: n1}

\item{convert}{Use \code{\link{which}} to get the row numbers?
DEFAULT: TRUE if i is boolean}
}
\value{
Nothing, calls \code{\link{View}}
}
\description{
View index rows of a data.frame with n surrounding rows
}
\examples{
\dontrun{ ## View should not be used in examples
myDF <- data.frame(A=1:30, B=cumsum(rnorm(30)))
myDF[c(5,7,23,29),1] <- NA
around(myDF, i=is.na(myDF$A))
around(myDF, i=c(11,19), n2=0)
}

}
\seealso{
\code{\link{sortDF}}, \code{\link{View}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Nov 2016
}
