% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logHist.R
\name{logHist}
\alias{logHist}
\title{Histogram of logarithmic values}
\usage{
logHist(x, logargs = NULL, main = xmain, xlab = xname, col = "tan", ...)
}
\arguments{
\item{x}{Vector of numerical values}

\item{logargs}{A list of arguments passed to \code{\link{logAxis}}. DEFAULT: NULL}

\item{main}{Title of graph, internally from x. DEFAULT: internal name representation}

\item{xlab}{X axis label. DEFAULT: internal: name of x}

\item{col}{Color of histogram bars}

\item{\dots}{further arguments passed to \code{\link{hist}} like breaks, freq, xlim=c(-1,3), ..., but not xaxt or add.}
}
\value{
none
}
\description{
Draw histogram of values on a logarithmic scale with nice axis labels
}
\examples{

dat <- rbeta(1e4, 2, 18)*100
hist(dat, col="tan", breaks=50)
logHist(dat, breaks=50)
logHist(dat,xlim=c(0,2)) # xlim in powers of ten
logHist(c(-1,0,1,2,2,3,3,4,8,10,50)) # warning for negative values

}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Feb 2016
}
\seealso{
\code{\link{logAxis}}, \code{\link{hist}}
}
\keyword{aplot}
\keyword{dplot}

