% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/get.functions.R
\name{getSuspects}
\alias{getSuspects}
\title{Gets the 'suspicious' observations according to Benford's Law}
\usage{
getSuspects(bfd, data, by="absolute.diff", how.many=2)
}
\arguments{
\item{bfd}{an object of class "Benford". See \code{\link{benford}}.}

\item{data}{the original data used for the benford analysis.}

\item{by}{a character string selecting how to order the digits.It can be
'abs.excess.summation','difference','squared.diff' or'absolute.diff'.}

\item{how.many}{how many groups of digits to get.}
}
\value{
The 'suspicious' observations from the original data.
}
\description{
It gets the original data from the 'suspicious' digits groups according
to benford analysis.
}
\examples{
data(lakes.perimeter) #gets data
lk <- benford(lakes.perimeter[,1]) #generates benford object
suspects <- getSuspects(lk, lakes.perimeter)
}

