% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{vcov.bellreg}
\alias{vcov.bellreg}
\title{Variance-covariance matrix for a bellreg model}
\usage{
\method{vcov}{bellreg}(object, ...)
}
\arguments{
\item{object}{an object of the class bellreg.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
the variance-covariance matrix associated with the regression coefficients.
}
\description{
This function extracts and returns the variance-covariance matrix associated with the regression coefficients when the maximum likelihood estimation approach is used in the model fitting.
}
\examples{
\donttest{
data(faults)
fit <- bellreg(nf ~ lroll, data = faults)
vcov(fit)
}

}
