% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bellreg.R
\name{bellreg}
\alias{bellreg}
\title{Bell regression model}
\usage{
bellreg(
  formula,
  data = NULL,
  approach = c("mle", "bayes"),
  hessian = TRUE,
  link = c("log", "sqrt", "identity"),
  hyperpars = list(mu_beta = 0, sigma_beta = 10),
  ...
)
}
\arguments{
\item{formula}{an object of class "formula" (or one that can be coerced to that class): a symbolic description of the model to be fitted.}

\item{data}{an optional data frame, list or environment (or object coercible by as.data.frame to a data frame) containing the variables in the model. If not found in data, the variables are taken from environment(formula), typically the environment from which ypbp is called.}

\item{approach}{approach to be used to fit the model (mle: maximum likelihood; bayes: Bayesian approach).}

\item{hessian}{hessian logical; If TRUE (default), the hessian matrix is returned when approach="mle".}

\item{link}{assumed link function (log, sqrt or identiy); default is log.}

\item{hyperpars}{a list containing the hyperparameters associated with the prior distribution of the regression coefficients; if not specified then default choice is hyperpars = c(mu_beta = 0, sigma_beta = 10).}

\item{...}{further arguments passed to either \code{rstan::optimizing} or \code{rstan::sampling}.}
}
\value{
bellreg returns an object of class "bellreg" containing the fitted model.
}
\description{
Fits the Bell regression model to overdispersed count data.
}
\examples{
\donttest{
data(faults)
# ML approach:
mle <- bellreg(nf ~ lroll, data = faults, approach = "mle")
summary(mle)

# Bayesian approach:
bayes <- bellreg(nf ~ lroll, data = faults, approach = "bayes", refresh = FALSE)
summary(bayes)
}

}
