% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toy-data.R
\name{toy_activity_data}
\alias{toy_activity_data}
\alias{toy_ethoscope_data}
\alias{toy_dam_data}
\title{Generate toy activity and sleep data mimicking Drosophila behaviour in tubes}
\usage{
toy_activity_data(metadata = NULL, seed = 1, rate_range = 1/c(60, 10),
  duration = days(5), sampling_period = 10, ...)

toy_ethoscope_data(...)

toy_dam_data(...)
}
\arguments{
\item{metadata}{\link{data.frame} where every row defines an individual.
Typically \code{metadata} has, at least, the column \code{id}.
The default value (\code{NULL}), will generate data for a single animal.}

\item{seed}{random seed used (see \link{set.seed})}

\item{rate_range}{parameter defining the boundaries of the rate at which animals wake up.
It will be uniformly distributed between animals, but fixed within each animal.}

\item{duration}{length (in seconds) of the data to generate}

\item{sampling_period}{sampling period (in seconds) of the resulting data}

\item{...}{additional arguments to be passed to \code{simulate_animal_activity}}
}
\value{
a \link{behavr} table with the metadata columns as metavariables.
In addition to \code{id} and \code{t} columns different methods will output different variables:
\itemize{
\item \code{toy_activity_data} will have \code{asleep} and \code{moving} (1/10s)
\item \code{toy_dam_data} will have \code{activity} (1/60s)
\item \code{toy_ethoscope_data} will have \code{xy_dist_log10x1000}, \code{has_interacted} and \code{x} (2/1s)
}
}
\description{
This function generates random data that emulates some of the features of fruit fly activity and sleep.
This is designed \strong{exclusively to provide material for examples and tests} as
it generates "realistic" datasets of arbitrary length.
}
\examples{
# just one animal, no metadata needed
dt <- toy_ethoscope_data(duration = days(1))

# advanced, using a metadata
metadata <- data.frame(id = paste0("toy_experiment|",1:9),
                   condition = c("A", "B", "C"))

metadata
# Data that could come from the scopr package:
dt <- toy_ethoscope_data(metadata, duration = days(1))
print(dt)

# Some DAM-like data
dt <- toy_dam_data(metadata, seed = 2, duration = days(1))
print(dt)

# data where behaviour is annotated e.g. by a classifier
dt <- toy_activity_data(metadata, 1.5)
print(dt)
}
\references{
\itemize{
\item The relevant \href{https://rethomics.github.io/behavr.html#playing-with-toy-data}{rethomic tutorial section} -- explainig how to work with toy data.
}
}
\seealso{
\itemize{
\item \link{behavr} -- to formally create a behavr object
}
}
