% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind-behavr-list.R
\name{bind_behavr_list}
\alias{bind_behavr_list}
\title{Put together a list of \link{behavr} tables}
\usage{
bind_behavr_list(l)
}
\arguments{
\item{l}{list of \link{behavr}}
}
\value{
a single \link{behavr} object
}
\description{
Bind all rows of both data and metadata from a list of \link{behavr} tables into a single one.
It checks keys, number and names of columns are the same across all data.
In addition, it forbids to bind metadata that would result in duplicates (same id in two different metadata).
}
\examples{
met <- data.table::data.table(id = 1:5,
                             condition = letters[1:5],
                             sex = c("M", "M", "M", "F", "F"),
                             key = "id")
data <- met[,list(t = 1L:100L,
                  x = rnorm(100),
                  y = rnorm(100),
                  eating = runif(100) > .5),
                  by = "id"]
d1 <- behavr(data, met)

met[,id := id + 5]
data[,id := id + 5]
data.table::setkeyv(met, "id")
data.table::setkeyv(data, "id")

d2 <- behavr(data, met)
d_all <- bind_behavr_list(list(d1, d2))
print(d_all)
}
\seealso{
\itemize{
\item \link{behavr} -- the documentation of the \code{behavr} object
}
}
