% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/are_equal_xml_lines.R
\name{are_equal_xml_lines}
\alias{are_equal_xml_lines}
\title{Determine if XML lines result in equal trees}
\usage{
are_equal_xml_lines(lines_1, lines_2, section)
}
\arguments{
\item{lines_1}{lines of a first XML file}

\item{lines_2}{lines of a second XML file}

\item{section}{name of an XML section.
Assumes that there is one line that starts with \code{<section}
(excluding whitespace)
and one line that is \code{</section>} (also excluding whitespace)}
}
\value{
TRUE if the two sections of the XML files are equal,
  FALSE otherwise
}
\description{
Determine if XML lines result in equal trees
}
\examples{
check_empty_beautier_folder()

are_equal_xml_lines(
  lines_1 = readLines(get_beautier_path("2_4.xml")),
  lines_2 = readLines(get_beautier_path("2_6_0.xml")),
  section = "taxonset"
)

check_empty_beautier_folder()
}
\author{
Richèl J.C. Bilderbeek
}
