% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_site_model.R
\name{is_tn93_site_model}
\alias{is_tn93_site_model}
\title{Determine if the object is a valid TN93 site model,}
\usage{
is_tn93_site_model(x)
}
\arguments{
\item{x}{an object, to be determined if it is a valid TN93 site model,
as created by \code{\link{create_tn93_site_model}}}
}
\value{
TRUE if x is a valid TN93 site model, FALSE otherwise
}
\description{
Determine if the object is a valid TN93 site model,
}
\examples{

# site models
is_tn93_site_model(create_gtr_site_model())
is_tn93_site_model(create_hky_site_model())
is_tn93_site_model(create_jc69_site_model())
is_tn93_site_model(create_tn93_site_model())

# other models
is_tn93_site_model(NA)
is_tn93_site_model(NULL)
is_tn93_site_model("nonsense")
is_tn93_site_model("")
is_tn93_site_model(c())
is_tn93_site_model(create_strict_clock_model())
is_tn93_site_model(create_bd_tree_prior())
is_tn93_site_model(create_mcmc())
}
\author{
Richèl J.C. Bilderbeek
}
