% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_phylogeny.R
\name{check_phylogeny}
\alias{check_phylogeny}
\title{Check if the phylogeny is a valid phylogeny object.}
\usage{
check_phylogeny(phylogeny)
}
\arguments{
\item{phylogeny}{a phylogeny of type \code{phylo} from the \code{ape}
package}
}
\value{
nothing
}
\description{
Calls \code{stop} if the phylogeny is invalid
}
\examples{

# Must do nothing on phylogenies
phylogeny <- ape::read.tree(text = "(A:1, B:1):1;")
check_phylogeny(phylogeny)
}
\seealso{
Use \code{ape::read.tree} to create a phylogeny
}
\author{
Richèl J.C. Bilderbeek
}
