% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_site_model.R
\name{is_site_model}
\alias{is_site_model}
\title{Determine if the object is a valid site_model}
\usage{
is_site_model(x)
}
\arguments{
\item{x}{an object, to be determined if it is a site_model}
}
\value{
TRUE if the site_model is a valid site_model, FALSE otherwise
}
\description{
Determine if the object is a valid site_model
}
\examples{
library(testthat)

# site models
expect_true(is_site_model(create_gtr_site_model()))
expect_true(is_site_model(create_hky_site_model()))
expect_true(is_site_model(create_jc69_site_model()))
expect_true(is_site_model(create_tn93_site_model()))

# other models
expect_false(is_site_model(NA))
expect_false(is_site_model(NULL))
expect_false(is_site_model("nonsense"))
expect_false(is_site_model(create_strict_clock_model()))
expect_false(is_site_model(create_bd_tree_prior()))
expect_false(is_site_model(create_mcmc()))
}
\seealso{
A site model can be created using \code{\link{create_site_model}}
}
