% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_site_models_n_distrs.R
\name{get_site_models_n_distrs}
\alias{get_site_models_n_distrs}
\title{Get the number of distributions a site model has}
\usage{
get_site_models_n_distrs(site_models)
}
\arguments{
\item{site_models}{one or more site models,
as returned by \code{\link{create_site_model}}}
}
\value{
the number of distributions the site models have
}
\description{
Get the number of distributions a site model has
}
\examples{
library(testthat)

expect_equal(get_site_models_n_distrs(list(create_gtr_site_model())), 5)
expect_equal(get_site_models_n_distrs(list(create_hky_site_model())), 1)
expect_equal(get_site_models_n_distrs(list(create_jc69_site_model())), 0)
expect_equal(get_site_models_n_distrs(list(create_tn93_site_model())), 2)
}
\author{
Richèl J.C. Bilderbeek
}
