% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_inference_model_filenames.R
\name{get_inference_model_filenames}
\alias{get_inference_model_filenames}
\title{Get the filenames stored in an inference model.}
\usage{
get_inference_model_filenames(inference_model)
}
\arguments{
\item{inference_model}{a Bayesian phylogenetic inference model.
An inference model is the complete model setup in which a site model,
clock model, tree prior and more are specified.
Use \link{create_inference_model} to create an inference model.
Use \link{check_inference_model} to check if  an inference model is valid.
Use \link{rename_inference_model_filenames} to rename the files in an
inference model.}
}
\description{
If there is no name for a \code{tipdates} file specified (as done by
setting \code{inference_model$tipdates_filename} to \link{NA},
there will be one filename less returned
}
\examples{
library(testthat)

inference_model <- create_inference_model()
inference_model$mcmc$tracelog$filename <- "/home/john/trace.log"
inference_model$mcmc$screenlog$filename <- "/home/john/screen.log"
inference_model$mcmc$treelog$filename <- "/home/john/tree.log"
inference_model$tipdates_filename <- "/home/john/tipdate.csv"

filenames <- get_inference_model_filenames(inference_model)

expect_equal(length(filenames), 4)
expect_true("/home/john/trace.log" \%in\% filenames)
expect_true("/home/john/screen.log" \%in\% filenames)
expect_true("/home/john/tree.log" \%in\% filenames)
expect_true("/home/john/tipdate.csv" \%in\% filenames)

#' Nope, no tip dates needed in my inference ...
inference_model$tipdates_filename <- NA
filenames <- get_inference_model_filenames(inference_model)

#' ... so one less file gets created
expect_equal(length(filenames), 3)
}
