% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_phylogeny.R
\name{check_phylogeny}
\alias{check_phylogeny}
\title{Check if the phylogeny is a valid phylogeny object.}
\usage{
check_phylogeny(phylogeny)
}
\arguments{
\item{phylogeny}{a phylogeny of type \link[ape]{phylo}}
}
\value{
nothing
}
\description{
Calls \code{stop} if the phylogeny is invalid
}
\examples{
library(testthat)

# Must do nothing on phylogenies
phylogeny <- ape::read.tree(text = "(A:1, B:1):1;")
expect_silent(check_phylogeny(phylogeny))

# Must stop on non-phylogenies
expect_error(check_phylogeny("nonsense"))
expect_error(check_phylogeny(NULL))
expect_error(check_phylogeny(NA))
expect_error(check_phylogeny(c()))
expect_error(check_phylogeny(c(3, 1, 4)))
}
\seealso{
Use \link[ape]{read.tree} to create a phylogeny
}
\author{
Richèl J.C. Bilderbeek
}
