% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_mcmc.R
\name{check_mcmc}
\alias{check_mcmc}
\title{Check if the MCMC is a valid MCMC object.}
\usage{
check_mcmc(mcmc)
}
\arguments{
\item{mcmc}{one MCMC
as returned by \code{\link{create_mcmc}}}
}
\value{
nothing
}
\description{
Calls \code{stop} if the MCMC is invalid
}
\examples{
library(testthat)

expect_silent(check_mcmc(create_mcmc()))

 # Must stop on non-MCMCs
expect_error(check_mcmc(mcmc = "nonsense"))
expect_error(check_mcmc(mcmc = NULL))
expect_error(check_mcmc(mcmc = NA))
}
\seealso{
Use \link{create_mcmc} to create a valid MCMC
}
\author{
Richèl J.C. Bilderbeek
}
