% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_id.R
\name{get_id}
\alias{get_id}
\title{Conclude the ID from a FASTA filename}
\usage{
get_id(fasta_filename, capitalize_first_char_id = FALSE)
}
\arguments{
\item{fasta_filename}{name of a FASTA file}

\item{capitalize_first_char_id}{capitalize the first character of the ID}
}
\value{
the ID
}
\description{
Conclude the ID from a FASTA filename
}
\examples{
  testit::assert(get_id("anthus_aco.fas") == "anthus_aco")
  testit::assert(
    get_id("anthus_aco.fas", capitalize_first_char_id = TRUE)
    == "Anthus_aco")
}
\seealso{
Use \code{\link{get_ids}} for one or more filenames
}
\author{
Richel J.C. Bilderbeek
}
