% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_distr.R
\name{create_normal_distr}
\alias{create_normal_distr}
\alias{create_distr_normal}
\title{Create an normal distribution}
\usage{
create_normal_distr(id = NA, mean = create_mean_param(),
  sigma = create_sigma_param())
}
\arguments{
\item{id}{the distribution's ID}

\item{mean}{the mean parameter
as returned by \code{\link{create_mean_param}}}

\item{sigma}{the sigma parameter
as returned by \code{\link{create_sigma_param}}}
}
\value{
a normal distribution
}
\description{
Create an normal distribution
}
\examples{
  normal_distr <- create_normal_distr()

  create_beast2_input_file(
    input_filenames = get_fasta_filename(),
    "my_beast.xml",
    tree_priors = create_yule_tree_prior(
      birth_rate_distr = normal_distr
    )
  )
  testit::assert(file.exists("my_beast.xml"))
}
\seealso{
the function \code{\link{create_distr}} shows an overview
  of all supported distributions
}
\author{
Richel J.C. Bilderbeek
}
