% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/animate_hr.R
\name{animate_hr}
\alias{animate_hr}
\title{Animate ECG data and heart beats}
\usage{
animate_hr(ecg, beats, which_beats = NULL, big = FALSE)
}
\arguments{
\item{ecg}{A data.frame with columns timestamp (POSIXct) and ecg (numeric)
(see \code{\link{read_ube}})}

\item{beats}{A data.frame with columns timestamp (POSIXct), ecg, period_s,
freq_hz, and freq_bpm (see \code{\link{find_hr}})}

\item{which_beats}{Indices of the heart beats (in param \code{beats}) to be
animated. If NULL (default), all beats will be animated.}

\item{big}{If FALSE (default) then throw an error if the animation will last
more than 20s. This prevents R from crashing if it tries to animate too
much.}
}
\value{
A \code{\link[gganimate]{gif_image}} object
}
\description{
\code{animate_hr} produces a GIF of heart beats in (close to) real time.
}
\examples{
\donttest{
  animate_hr(ecg_bw190918_62R, beats_bw190918_62R, which_beats = 44:50, big = TRUE)
}

}
