% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ps.R
\name{calc_prop_scr}
\alias{calc_prop_scr}
\title{Create a Propensity Score Object}
\usage{
calc_prop_scr(internal_df, external_df, id_col, model, ...)
}
\arguments{
\item{internal_df}{Internal dataset with one row per subject and all the
variables needed to run the model}

\item{external_df}{External dataset with one row per subject and all the
variables needed to run the model}

\item{id_col}{Name of the column in both datasets used to identify each
subject. It must be the same across datasets}

\item{model}{Model used to calculate propensity scores}

\item{...}{Optional arguments}
}
\value{
\code{prop_scr_obj} object, with the internal and the external data and
the propensity score and inverse probability weight calculated for each
subject.
}
\description{
Calculate the propensity scores and ATT inverse probability
weights for participants from internal and external datasets. Only the
relevant treatment arms from each dataset should be read in (e.g., only
the control arm from each dataset if creating a hybrid control arm).
}
\details{
For the subset of participants in both the external and internal
studies for which we want to balance the covariate distributions (e.g.,
external control and internal control participants if constructing a
hybrid control arm), we define a study-inclusion propensity score for
each participant as

\deqn{e(x_i) = P(S_i = 1 \mid x_i),}

where \eqn{x_i} denotes a vector of baseline covariates for the \eqn{i}th
participant and \eqn{S_i} denotes the indicator that the participant is
enrolled in the internal trial (\eqn{S_i = 1} if internal, \eqn{S_i = 0}
if external). The estimated propensity score \eqn{\hat{e}(x_i)} is obtained
using logistic regression.

An ATT inverse probability weight is calculated for each individual as

\deqn{\hat{a}_{0i} = \frac{\hat{e}(x_i)}{\hat{P}(S_i = s_i | x_i)} = s_i + (1 - s_i ) \frac{\hat{e}(x_i)}{1 - \hat{e}(x_i)}.}

In a weighted estimator, data from participants in the external study
are given a weight of \eqn{\hat{e}(x_i)⁄(1 - \hat{e}(x_i))} whereas data
from participants in the internal trial are given a weight of 1.
}
\examples{
# This can be used for both continuous and binary data
library(dplyr)
# Continuous
calc_prop_scr(internal_df = filter(int_norm_df, trt == 0),
                       external_df = ex_norm_df,
                       id_col = subjid,
                       model = ~ cov1 + cov2 + cov3 + cov4)
# Binary
calc_prop_scr(internal_df = filter(int_binary_df, trt == 0),
                       external_df = ex_binary_df,
                       id_col = subjid,
                       model = ~ cov1 + cov2 + cov3 + cov4)

}
