% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_rng_seed.R
\name{check_rng_seed}
\alias{check_rng_seed}
\title{Check if the input is a valid RNG seed.}
\usage{
check_rng_seed(rng_seed)
}
\arguments{
\item{rng_seed}{the random number generator seed of the BEAST2 run.
Must be a non-zero positive integer value or \link{NA}.
If \code{rng_seed} is \link{NA}, BEAST2 will pick a random seed}
}
\value{
Nothing.
Will \link{stop} if the RNG seed is invalid
}
\description{
Will \link{stop} if not.
}
\examples{
# Numbers from 1 and higher are valid RNG seeds
check_rng_seed(1)
check_rng_seed(2)
# Also NA is a valid RNG seed
check_rng_seed(NA)
}
\author{
Richèl J.C. Bilderbeek
}
