% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_beast2_options.R
\name{check_beast2_options}
\alias{check_beast2_options}
\title{Check if the \code{beast2_options} is a valid BEAST2 options object.}
\usage{
check_beast2_options(beast2_options)
}
\arguments{
\item{beast2_options}{a set of BEAST2 options,
that are the R equivalent of the BEAST2 command-line options,
as can be created by \link{create_beast2_options}}
}
\value{
nothing
}
\description{
Calls \code{stop} if the BEAST2 option object is invalid
}
\examples{
library(testthat)

expect_silent(check_beast2_options(create_beast2_options()))

# Must stop on nonsense
expect_error(check_beast2_options("nonsense"))
expect_error(check_beast2_options(NULL))
expect_error(check_beast2_options(NA))
}
\seealso{
Use \link{create_beast2_options} to create a valid
  BEAST2 options object
}
\author{
Richèl J.C. Bilderbeek
}
