% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beanz_present.R
\name{bzSummary}
\alias{bzForest}
\alias{bzPlot}
\alias{bzSummary}
\title{Posterior subgroup treatment effects}
\usage{
bzSummary(stan.rst, sel.grps = NULL, ref.stan.rst = NULL,
  ref.sel.grps = 1, cut = 0, digits = 3)

bzPlot(stan.rst, sel.grps = NULL, ref.stan.rst = NULL, ref.sel.grps = 1,
  ...)

bzForest(stan.rst, sel.grps = NULL, ref.stan.rst = NULL, ref.sel.grps = 1,
  ..., quants = c(0.025, 0.975))
}
\arguments{
\item{stan.rst}{a class \code{beanz.stan} object generated by
\code{\link{bzCallStan}}}

\item{sel.grps}{an array of subgroup numbers to be included in the summary results}

\item{ref.stan.rst}{a class \code{beanz.stan} object from \code{\link{bzCallStan}} that
is used as the reference}

\item{ref.sel.grps}{subgroups from the reference model to be included in the
summary table}

\item{cut}{cut point to compute the probabiliby that the posterior subgroup
treatment effects is below}

\item{digits}{number of digits in the summary result table}

\item{...}{options for \code{plot} function}

\item{quants}{lower and upper quantiles of the credible intervals in the
forest plot}
}
\value{
\code{bzSummary} generates a dataframe with summary statistics
    of the posterior treatment effect for the selected subgroups.
    \code{bzPlot} generates the density plot of the posterior treatment
    effects for the selected subgroups. \code{bzForest}
    generates the forest plot of the posterior treatment
    effects.
}
\description{
Present the posterior subgroup treatment effects
}
\examples{
\dontrun{
sel.grps <- c(1,4,5);
tbl.sub <- bzSummary(rst.sr, ref.stan.rst=rst.nse, ref.sel.grps=1);
bzPlot(rst.sr, sel.grps = sel.grps, ref.stan.rst=rst.nse, ref.sel.grps=1);
bzForest(rst.sr, sel.grps = sel.grps, ref.stan.rst=rst.nse, ref.sel.grps=1);}

}
\seealso{
\code{\link{bzCallStan}}
}

