% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SEM_matrices.R
\name{sem_psi_matrix}
\alias{sem_psi_matrix}
\title{Matrix with psi parameters for SEM representation}
\usage{
sem_psi_matrix(psis, timestamps_n, features_n)
}
\arguments{
\item{psis}{double vector with psi parameter values}

\item{timestamps_n}{number of time stamps (e.g. years)}

\item{features_n}{number of features (e.g. population size, investment rate)}
}
\value{
A matrix with \code{timestamps_n} rows and
\code{(timestamps_n - 1) * feature_n} columns. Psis are filled in row by row
in a block manner, i.e. blocks of size \code{feature_n} are placed next to
each other
}
\description{
Matrix with psi parameters for SEM representation
}
\examples{
sem_psi_matrix(1:30, 4, 5)
}
