% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.BDA}
\alias{summary.BDA}
\title{Summarize Beta Drift Analyses}
\usage{
\method{summary}{BDA}(object, ...)
}
\arguments{
\item{object}{an object of class \code{BDA}.}

\item{...}{additional parameters.}
}
\description{
\code{summary.BDA} summarizes the results of beta drift analyses.
}
\details{
This function prints a detailed summary of the analyses produced by
the \code{\link{BDA}} function.
}
\examples{
\dontrun{
###################################################
####             Full example                  ####
###################################################

results <- BDA(data = FFfactors, spec = (VOO~SP500),
               horizon = 250, doplot = TRUE)
summary(results)
}

###################################################
####        CRAN-compatible example            ####
###################################################

results <- BDA(data = FFfactors[nrow(FFfactors):(nrow(FFfactors)-300),], 
               spec = (VOO~SP500),horizon = 250, doplot = FALSE)
summary(results)
message("NOTE: This is a shortened example. Reference the manual for more complex examples")
}
\author{
Markus Peter Auer <mp.auer@meanerreversion.com>
}

