% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bdpar.R
\docType{class}
\name{Bdpar}
\alias{Bdpar}
\title{Class to manage the preprocess of the files throughout the flow of pipes}
\usage{
Bdpar
}
\description{
\code{Bdpar} class provides the static variables required
to perform the whole data flow process. To this end \code{Bdpar} is
in charge of (i) initialize the objects of handle the connections to APIs
(\code{\link{Connections}}) and handles json resources (\code{\link{ResourceHandler}})
and (ii) executing the flow of pipes (inherited from \code{\link{GenericPipeline}} class)
passed as argument.
}
\section{Constructor}{

\code{Bdpar$new()}
}

\section{Details}{

In the case that some pipe, defined on the workflow, needs some type of configuration,
it can be defined throught \emph{\link{bdpar.Options}} variable
which have differents methods to support the funcionality of different pipes.
}

\section{Static variables}{

\itemize{
\item{\bold{connections}:}{
(\emph{Connections}) object that handles the connections with YouTube and
Twitter.
}
\item{\bold{resourceHandler}:}{
(\emph{ResourceHandler}) object that handles the json resources files.
}
}
}

\section{Methods}{

\itemize{
\item{\bold{execute}:}{
preprocess files through the indicated flow of pipes.
\itemize{
\item{\emph{Usage}:}{
\preformatted{
execute(path,
        extractors = ExtractorFactory$new(),
        pipeline = GenericPipeline$new())}

}
\item{\emph{Value}:}{
list of \code{Instances} that have been preprocessed.
}
\item{\emph{Arguments}:}{
\itemize{
\item{\strong{path}:}{
(\emph{character}) path where the files to be processed are located.
}
\item{\strong{extractors}:}{
(\emph{ExtractorFactory}) class which implements the  \code{createInstance} method
to choose which type of \code{\link{Instance}} is created.
}
\item{\strong{pipeline}:}{
(\emph{GenericPipeline}) subclass of \code{\link{GenericPipeline}}, which implements the \code{execute} method.
}
}
}
}
}
}
}

\examples{
\dontrun{

#If it is necessary to indicate any existing configuration key, do it through:
#bdpar.Options$set(key, value)
#If the key is not initialized, do it through:
#bdpar.Options$add(key, value)

#Folder with the files to preprocess
path <- system.file(file.path("example"),
                    package = "bdpar")

#Object which decides how creates the instances
extractors <- ExtractorFactory$new()

#Object which indicates the pipes' flow
pipeline <- DefaultPipeline$new()

objectBdpar <- Bdpar$new()

#Starting file preprocessing...
objectBdpar$execute(path = path,
                    extractors = extractors,
                    pipeline = pipeline)
}
}
\seealso{
\code{\link{bdpar.Options}}, \code{\link{Connections}},
         \code{\link{DefaultPipeline}}, \code{\link{DynamicPipeline}},
         \code{\link{GenericPipeline}},\code{\link{Instance}},
         \code{\link{ExtractorFactory}}, \code{\link{ResourceHandler}},
         \code{\link{runPipeline}}
}
