% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatter_2var_plot.R
\name{scatter_2var_plot}
\alias{scatter_2var_plot}
\title{Generate quick scatter correlation plot}
\usage{
scatter_2var_plot(data_type = c("variable", "variable.locality"), varId,
  year = NULL, unitParentId = NULL, unitLevel = NULL,
  aggregateId = NULL, lang = c("pl", "en"), ...)
}
\arguments{
\item{data_type}{A type of data used for generating plot, "variable"(default), "variable.locality"}

\item{varId}{A vector of 2 variable Id's. Use \code{\link{search_variables}} or
\code{\link{get_variables}} to find variable id code.}

\item{year}{A vector of years. If \code{NULL} (default) returns data for all available years.}

\item{unitParentId}{A 12 character NUTS id code of interested unit. 
(Used only with data_type equal "variable" or "variable.locality")Use \code{\link{search_units}} or
\code{\link{get_units}} to find unit id code.}

\item{unitLevel}{A number from 0 to 6, filters the returned unit by its level. 
(Used only with data_type equal "variable")
If \code{NULL} (default) no level filters apply. Use \code{\link{get_levels}} to find more info.}

\item{aggregateId}{An aggregate id. Use \code{\link{get_aggregates}} for more info.}

\item{lang}{A language of returned data, "pl" (default), "en"}

\item{...}{Other arguments passed on to \code{\link[httr]{GET}}. For example
a proxy parameters, see details.}
}
\value{
A ggplot2 plot.
}
\description{
Generate scatter correlation plot for 2 variables
}
\details{
Generate quickly `ggplot2` scatter correlation plot, using BDL data.
  
  Scatter plot 2 variables for given units with regression line, confidence interval and
  correlation coefficient.
  
  To use a proxy to connect, a \code{\link[httr]{use_proxy}} can be
  passed to \code{\link[httr]{GET}}. For example
  \code{get_request(id, filters,
  config = httr::use_proxy(url, port, username, password))}.
}
\examples{
\donttest{
   scatter_2var_plot(data_type ="variable" ,c("60559","415"), unitLevel = "2")
 }
}
