# Copyright 2018 Province of British Columbia
  #
  # Licensed under the Apache License, Version 2.0 (the "License");
  # you may not use this file except in compliance with the License.
  # You may obtain a copy of the License at
  #
  # http://www.apache.org/licenses/LICENSE-2.0
  #
  # Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS,
  # WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  # See the License for the specific language governing permissions and limitations under the License.
  
#############################################################
# This file is automatically generated by running the function
# bcmaps:::make_shortcuts(). Do not edit by hand.
#############################################################

#' British Columbia Air Zones
#'
#' You must have the `bcmaps.rdata` package installed to use this function.
#'
#' @param class what class you want the object in? `"sf"` (default) or `"sp"`.
#'
#' @return The spatial layer of `airzones` in the desired class
#'
#' @details Type `?bcmaps.rdata::airzones` for details.
#'
#' 
#'
#' @examples
#' \dontrun{
#' my_layer <- airzones()
#' my_layer_sp <- airzones(class = 'sp')
#' }
#'
#' @export
airzones <- function(class = 'sf') {
   get_layer('airzones', class = class)
}

#' BC Boundary
#'
#' You must have the `bcmaps.rdata` package installed to use this function.
#'
#' @param class what class you want the object in? `"sf"` (default) or `"sp"`.
#'
#' @return The spatial layer of `bc_bound` in the desired class
#'
#' @details Type `?bcmaps.rdata::bc_bound` for details.
#'
#' 
#'
#' @examples
#' \dontrun{
#' my_layer <- bc_bound()
#' my_layer_sp <- bc_bound(class = 'sp')
#' }
#'
#' @export
bc_bound <- function(class = 'sf') {
   get_layer('bc_bound', class = class)
}

#' BC Boundary - High Resolution
#'
#' You must have the `bcmaps.rdata` package installed to use this function.
#'
#' @param class what class you want the object in? `"sf"` (default) or `"sp"`.
#'
#' @return The spatial layer of `bc_bound_hres` in the desired class
#'
#' @details Type `?bcmaps.rdata::bc_bound_hres` for details.
#'
#' 
#'
#' @examples
#' \dontrun{
#' my_layer <- bc_bound_hres()
#' my_layer_sp <- bc_bound_hres(class = 'sp')
#' }
#'
#' @export
bc_bound_hres <- function(class = 'sf') {
   get_layer('bc_bound_hres', class = class)
}

#' BC Major Cities Points 1:2,000,000 (Digital Baseline Mapping)
#'
#' You must have the `bcmaps.rdata` package installed to use this function.
#'
#' @param class what class you want the object in? `"sf"` (default) or `"sp"`.
#'
#' @return The spatial layer of `bc_cities` in the desired class
#'
#' @details Type `?bcmaps.rdata::bc_cities` for details.
#'
#' 
#'
#' @examples
#' \dontrun{
#' my_layer <- bc_cities()
#' my_layer_sp <- bc_cities(class = 'sp')
#' }
#'
#' @export
bc_cities <- function(class = 'sf') {
   get_layer('bc_cities', class = class)
}

#' British Columbia Ecoprovinces
#'
#' You must have the `bcmaps.rdata` package installed to use this function.
#'
#' @param class what class you want the object in? `"sf"` (default) or `"sp"`.
#'
#' @return The spatial layer of `ecoprovinces` in the desired class
#'
#' @details Type `?bcmaps.rdata::ecoprovinces` for details.
#'
#' 
#'
#' @examples
#' \dontrun{
#' my_layer <- ecoprovinces()
#' my_layer_sp <- ecoprovinces(class = 'sp')
#' }
#'
#' @export
ecoprovinces <- function(class = 'sf') {
   get_layer('ecoprovinces', class = class)
}

#' British Columbia Ecoregions
#'
#' You must have the `bcmaps.rdata` package installed to use this function.
#'
#' @param class what class you want the object in? `"sf"` (default) or `"sp"`.
#'
#' @return The spatial layer of `ecoregions` in the desired class
#'
#' @details Type `?bcmaps.rdata::ecoregions` for details.
#'
#' 
#'
#' @examples
#' \dontrun{
#' my_layer <- ecoregions()
#' my_layer_sp <- ecoregions(class = 'sp')
#' }
#'
#' @export
ecoregions <- function(class = 'sf') {
   get_layer('ecoregions', class = class)
}

#' British Columbia Ecosections
#'
#' You must have the `bcmaps.rdata` package installed to use this function.
#'
#' @param class what class you want the object in? `"sf"` (default) or `"sp"`.
#'
#' @return The spatial layer of `ecosections` in the desired class
#'
#' @details Type `?bcmaps.rdata::ecosections` for details.
#'
#' 
#'
#' @examples
#' \dontrun{
#' my_layer <- ecosections()
#' my_layer_sp <- ecosections(class = 'sp')
#' }
#'
#' @export
ecosections <- function(class = 'sf') {
   get_layer('ecosections', class = class)
}

#' British Columbia's developed ground water aquifers
#'
#' You must have the `bcmaps.rdata` package installed to use this function.
#'
#' @param class what class you want the object in? `"sf"` (default) or `"sp"`.
#'
#' @return The spatial layer of `gw_aquifers` in the desired class
#'
#' @details Type `?bcmaps.rdata::gw_aquifers` for details.
#'
#' 
#'
#' @examples
#' \dontrun{
#' my_layer <- gw_aquifers()
#' my_layer_sp <- gw_aquifers(class = 'sp')
#' }
#'
#' @export
gw_aquifers <- function(class = 'sf') {
   get_layer('gw_aquifers', class = class)
}

#' Hydrologic Zone Boundaries of British Columbia
#'
#' You must have the `bcmaps.rdata` package installed to use this function.
#'
#' @param class what class you want the object in? `"sf"` (default) or `"sp"`.
#'
#' @return The spatial layer of `hydrozones` in the desired class
#'
#' @details Type `?bcmaps.rdata::hydrozones` for details.
#'
#' 
#'
#' @examples
#' \dontrun{
#' my_layer <- hydrozones()
#' my_layer_sp <- hydrozones(class = 'sp')
#' }
#'
#' @export
hydrozones <- function(class = 'sf') {
   get_layer('hydrozones', class = class)
}

#' British Columbia Municipalities
#'
#' You must have the `bcmaps.rdata` package installed to use this function.
#'
#' @param class what class you want the object in? `"sf"` (default) or `"sp"`.
#'
#' @return The spatial layer of `municipalities` in the desired class
#'
#' @details Type `?bcmaps.rdata::municipalities` for details.
#'
#' @seealso [combine_nr_rd()] to combine Regional Districts and the Northern Rockies Regional Municipality into one layer
#'
#' @examples
#' \dontrun{
#' my_layer <- municipalities()
#' my_layer_sp <- municipalities(class = 'sp')
#' }
#'
#' @export
municipalities <- function(class = 'sf') {
   get_layer('municipalities', class = class)
}

#' British Columbia Natural Resource (NR) Areas
#'
#' You must have the `bcmaps.rdata` package installed to use this function.
#'
#' @param class what class you want the object in? `"sf"` (default) or `"sp"`.
#'
#' @return The spatial layer of `nr_areas` in the desired class
#'
#' @details Type `?bcmaps.rdata::nr_areas` for details.
#'
#' 
#'
#' @examples
#' \dontrun{
#' my_layer <- nr_areas()
#' my_layer_sp <- nr_areas(class = 'sp')
#' }
#'
#' @export
nr_areas <- function(class = 'sf') {
   get_layer('nr_areas', class = class)
}

#' British Columbia Natural Resource (NR) Districts
#'
#' You must have the `bcmaps.rdata` package installed to use this function.
#'
#' @param class what class you want the object in? `"sf"` (default) or `"sp"`.
#'
#' @return The spatial layer of `nr_districts` in the desired class
#'
#' @details Type `?bcmaps.rdata::nr_districts` for details.
#'
#' 
#'
#' @examples
#' \dontrun{
#' my_layer <- nr_districts()
#' my_layer_sp <- nr_districts(class = 'sp')
#' }
#'
#' @export
nr_districts <- function(class = 'sf') {
   get_layer('nr_districts', class = class)
}

#' British Columbia Natural Resource (NR) Regions
#'
#' You must have the `bcmaps.rdata` package installed to use this function.
#'
#' @param class what class you want the object in? `"sf"` (default) or `"sp"`.
#'
#' @return The spatial layer of `nr_regions` in the desired class
#'
#' @details Type `?bcmaps.rdata::nr_regions` for details.
#'
#' 
#'
#' @examples
#' \dontrun{
#' my_layer <- nr_regions()
#' my_layer_sp <- nr_regions(class = 'sp')
#' }
#'
#' @export
nr_regions <- function(class = 'sf') {
   get_layer('nr_regions', class = class)
}

#' British Columbia Regional Districts
#'
#' You must have the `bcmaps.rdata` package installed to use this function.
#'
#' @param class what class you want the object in? `"sf"` (default) or `"sp"`.
#'
#' @return The spatial layer of `regional_districts` in the desired class
#'
#' @details Type `?bcmaps.rdata::regional_districts` for details.
#'
#' @seealso [combine_nr_rd()] to combine Regional Districts and the Northern Rockies Regional Municipality into one layer
#'
#' @examples
#' \dontrun{
#' my_layer <- regional_districts()
#' my_layer_sp <- regional_districts(class = 'sp')
#' }
#'
#' @export
regional_districts <- function(class = 'sf') {
   get_layer('regional_districts', class = class)
}

#' British Columbia's Water Management Districts
#'
#' You must have the `bcmaps.rdata` package installed to use this function.
#'
#' @param class what class you want the object in? `"sf"` (default) or `"sp"`.
#'
#' @return The spatial layer of `water_districts` in the desired class
#'
#' @details Type `?bcmaps.rdata::water_districts` for details.
#'
#' 
#'
#' @examples
#' \dontrun{
#' my_layer <- water_districts()
#' my_layer_sp <- water_districts(class = 'sp')
#' }
#'
#' @export
water_districts <- function(class = 'sf') {
   get_layer('water_districts', class = class)
}

#' British Columbia's Water Management Precincts
#'
#' You must have the `bcmaps.rdata` package installed to use this function.
#'
#' @param class what class you want the object in? `"sf"` (default) or `"sp"`.
#'
#' @return The spatial layer of `water_precincts` in the desired class
#'
#' @details Type `?bcmaps.rdata::water_precincts` for details.
#'
#' 
#'
#' @examples
#' \dontrun{
#' my_layer <- water_precincts()
#' my_layer_sp <- water_precincts(class = 'sp')
#' }
#'
#' @export
water_precincts <- function(class = 'sf') {
   get_layer('water_precincts', class = class)
}

#' British Columbia watercourses at 1:15M scale
#'
#' You must have the `bcmaps.rdata` package installed to use this function.
#'
#' @param class what class you want the object in? `"sf"` (default) or `"sp"`.
#'
#' @return The spatial layer of `watercourses_15M` in the desired class
#'
#' @details Type `?bcmaps.rdata::watercourses_15M` for details.
#'
#' 
#'
#' @examples
#' \dontrun{
#' my_layer <- watercourses_15M()
#' my_layer_sp <- watercourses_15M(class = 'sp')
#' }
#'
#' @export
watercourses_15M <- function(class = 'sf') {
   get_layer('watercourses_15M', class = class)
}

#' British Columbia watercourses at 1:5M scale
#'
#' You must have the `bcmaps.rdata` package installed to use this function.
#'
#' @param class what class you want the object in? `"sf"` (default) or `"sp"`.
#'
#' @return The spatial layer of `watercourses_5M` in the desired class
#'
#' @details Type `?bcmaps.rdata::watercourses_5M` for details.
#'
#' 
#'
#' @examples
#' \dontrun{
#' my_layer <- watercourses_5M()
#' my_layer_sp <- watercourses_5M(class = 'sp')
#' }
#'
#' @export
watercourses_5M <- function(class = 'sf') {
   get_layer('watercourses_5M', class = class)
}

#' Water Survey of Canada Sub-Sub-Drainage Areas
#'
#' You must have the `bcmaps.rdata` package installed to use this function.
#'
#' @param class what class you want the object in? `"sf"` (default) or `"sp"`.
#'
#' @return The spatial layer of `wsc_drainages` in the desired class
#'
#' @details Type `?bcmaps.rdata::wsc_drainages` for details.
#'
#' 
#'
#' @examples
#' \dontrun{
#' my_layer <- wsc_drainages()
#' my_layer_sp <- wsc_drainages(class = 'sp')
#' }
#'
#' @export
wsc_drainages <- function(class = 'sf') {
   get_layer('wsc_drainages', class = class)
}
