% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bcdc_search.R
\name{bcdc_search}
\alias{bcdc_search}
\title{Search the B.C. Data Catalogue}
\usage{
bcdc_search(
  ...,
  license_id = NULL,
  download_audience = NULL,
  res_format = NULL,
  sector = NULL,
  organization = NULL,
  groups = NULL,
  n = 100
)
}
\arguments{
\item{...}{search terms}

\item{license_id}{the type of license (see \code{bcdc_search_facets("license_id")}).}

\item{download_audience}{download audience
(see \code{bcdc_search_facets("download_audience")}). Default \code{NULL} (all audiences).}

\item{res_format}{format of resource (see \code{bcdc_search_facets("res_format")})}

\item{sector}{sector of government from which the data comes
(see \code{bcdc_search_facets("sector")})}

\item{organization}{government organization that manages the data
(see \code{bcdc_search_facets("organization")})}

\item{groups}{collections of datasets for a particular project or on a particular theme
(see \code{bcdc_search_facets("groups")})}

\item{n}{number of results to return. Default \code{100}}
}
\value{
A list containing the records that match the search
}
\description{
Search the B.C. Data Catalogue
}
\examples{
\donttest{
try(
  bcdc_search("forest")
)

try(
  bcdc_search("regional district", res_format = "fgdb")
)

try(
  bcdc_search("angling", groups = "bc-tourism")
)
}
}
