% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootProbit.R
\name{bootPROBIT}
\alias{bootPROBIT}
\title{PROBIT statistics function for bootstrap estimation}
\usage{
bootPROBIT(x, params, threshold = THRESHOLD)
}
\arguments{
\item{x}{A data frame with \strong{primary sampling unit (PSU)} in column named
\code{psu} and with data column/s containing the continuous variable/s of
interest with column names corresponding to \code{params} values}

\item{params}{A vector of column names corresponding to the continuous
variables of interest contained in \code{x}}

\item{threshold}{cut-off value for continuous variable to differentiate
case and non-case}
}
\value{
A numeric vector of the PROBIT estimate of each continuous variable
of interest with length equal to \code{length(params)}
}
\description{
PROBIT statistics function for bootstrap estimation
}
\examples{

# Example call to bootBW function:

bootPROBIT(x = indicatorsCH1,
           params = "muac1",
           threshold = 115)

}
