% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootBW.r
\name{bootBW}
\alias{bootBW}
\title{Blocked Weighted Bootstrap}
\usage{
bootBW(x, w, statistic, params, outputColumns, replicates = 400)
}
\arguments{
\item{x}{A data frame with primary sampling unit (PSU) in column named \code{psu}}

\item{w}{A data frame with primary sampling unit (PSU) in column named \code{psu}
and survey weight (i.e. PSU population) in column named \code{pop}}

\item{statistic}{A function operating on data in \code{x} (see example)}

\item{params}{Parameters (named columns in \code{x}) passed to the function
specified in \code{statistic}}

\item{outputColumns}{Names of columns in output data frame}

\item{replicates}{Number of bootstrap replicates}
}
\value{
A data frame with:
\itemize{
\item ncol = length(outputColumns)
\item nrow = replicates
\item names = outputColumns
}
}
\description{
The \strong{blocked weighted bootstrap (BBW)} is an estimation technique for
use with data from two-stage cluster sampled surveys in which either prior
weighting (e.g. \strong{population proportional sampling} or \strong{PPS} as
used in \strong{SMART} surveys) or posterior weighting (e.g. as used in
\strong{RAM} and \strong{S3M} surveys).
}
\examples{
# Example function - estimate a proportion for a binary (0/1) variable):

oneP <- function(x, params) {
  v1 <- params[1]
  v1Data <- x[[v1]]
  oneP <- mean(v1Data, na.rm = TRUE)
  return(oneP)
}

# Example call to bootBW function using RAM-OP test data:

bootP <- bootBW(x = indicatorsHH,
                w = villageData,
                statistic = oneP,
                params = "anc1",
                outputColumns = "anc1",
                replicates = 9)

# Example estimate with 95\% CI:

quantile(bootP, probs = c(0.500, 0.025, 0.975), na.rm = TRUE)

}
