% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explore_functions.R
\name{plot.bbreg}
\alias{plot.bbreg}
\title{plot.bbreg}
\usage{
\method{plot}{bbreg}(x, which = c(1, 2, 3, 4), ask = TRUE, qqline = TRUE, ...)
}
\arguments{
\item{x}{object of class "bbreg" containing results from the fitted model.
If the model is fitted with envelope = 0, the Q-Q plot will be produced without envelopes.}

\item{which}{a number of a vector of numbers between 1 and 4. Plot 1:
Residuals vs. Index; Plot 2: Q-Q Plot (if the fit contains simulated envelopes,
the plot will be with the simulated envelopes); Plot 3: Fitted means vs. Response;
Plot 4: Residuals vs. Fitted means.}

\item{ask}{logical; if \code{TRUE}, the user is aked before each plot.}

\item{qqline}{logical; if \code{TRUE} and the fit does \emph{not} contain simulated
envelopes, a qqline will be added to the normal Q-Q plot.
simulated envelopes.}

\item{...}{graphical parameters to be passed.}
}
\description{
Function to build useful plots for bounded regression models.
}
\examples{
\donttest{
n = 100; x = cbind(rbinom(n, 1, 0.5), runif(n, -1, 1)); v = runif(n, -1, 1);
z = simdata_bes(kap = c(1, 1, -0.5), lam = c(0.5, -0.5), x, v, repetitions = 1,
link.mean = "logit", link.precision = "log")
z = unlist(z)
fit = bbreg(z ~ x | v, envelope = 10)
plot(fit)
plot(fit, which = 2)
plot(fit, which = c(1,4), ask = FALSE)}
}
\seealso{
\code{\link{summary}}, \code{\link{coef}}, \code{\link{vcov}}, \code{\link{fitted}}, \code{\link{predict}}
}
