% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OptimizerBatchCmaes.R
\name{mlr_optimizers_cmaes}
\alias{mlr_optimizers_cmaes}
\alias{OptimizerBatchCmaes}
\title{Optimization via Covariance Matrix Adaptation Evolution Strategy}
\description{
\code{OptimizerBatchCmaes} class that implements CMA-ES. Calls \code{\link[adagio:cmaes]{adagio::pureCMAES()}}
from package \CRANpkg{adagio}. The algorithm is typically applied to search
space dimensions between three and fifty. Lower search space dimensions might
crash.
}
\section{Dictionary}{

This \link{Optimizer} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary}
\link{mlr_optimizers} or with the associated sugar function \code{\link[=opt]{opt()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_optimizers$get("cmaes")
opt("cmaes")
}\if{html}{\out{</div>}}
}

\section{Parameters}{

\describe{
\item{\code{sigma}}{\code{numeric(1)}}
\item{\code{start_values}}{\code{character(1)}\cr
Create \code{random} start values or based on \code{center} of search space? In the
latter case, it is the center of the parameters before a trafo is applied.}
}

For the meaning of the control parameters, see \code{\link[adagio:cmaes]{adagio::pureCMAES()}}. Note
that we have removed all control parameters which refer to the termination of
the algorithm and where our terminators allow to obtain the same behavior.
}

\section{Progress Bars}{

\verb{$optimize()} supports progress bars via the package \CRANpkg{progressr}
combined with a \link{Terminator}. Simply wrap the function in
\code{progressr::with_progress()} to enable them. We recommend to use package
\CRANpkg{progress} as backend; enable with \code{progressr::handlers("progress")}.
}

\examples{
if (requireNamespace("adagio")) {
  search_space = domain = ps(
    x1 = p_dbl(-10, 10),
    x2 = p_dbl(-5, 5)
  )

  codomain = ps(y = p_dbl(tags = "maximize"))

  objective_function = function(xs) {
    c(y = -(xs[[1]] - 2)^2 - (xs[[2]] + 3)^2 + 10)
  }

  objective = ObjectiveRFun$new(
    fun = objective_function,
    domain = domain,
    codomain = codomain)

  instance = OptimInstanceBatchSingleCrit$new(
    objective = objective,
    search_space = search_space,
    terminator = trm("evals", n_evals = 10))

  optimizer = opt("cmaes")

  # modifies the instance by reference
  optimizer$optimize(instance)

  # returns best scoring evaluation
  instance$result

  # allows access of data.table of full path of all evaluations
  as.data.table(instance$archive$data)
}
}
\section{Super classes}{
\code{\link[bbotk:Optimizer]{bbotk::Optimizer}} -> \code{\link[bbotk:OptimizerBatch]{bbotk::OptimizerBatch}} -> \code{OptimizerBatchCmaes}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-OptimizerBatchCmaes-new}{\code{OptimizerBatchCmaes$new()}}
\item \href{#method-OptimizerBatchCmaes-clone}{\code{OptimizerBatchCmaes$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="format"><a href='../../bbotk/html/Optimizer.html#method-Optimizer-format'><code>bbotk::Optimizer$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="help"><a href='../../bbotk/html/Optimizer.html#method-Optimizer-help'><code>bbotk::Optimizer$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="print"><a href='../../bbotk/html/Optimizer.html#method-Optimizer-print'><code>bbotk::Optimizer$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="OptimizerBatch" data-id="optimize"><a href='../../bbotk/html/OptimizerBatch.html#method-OptimizerBatch-optimize'><code>bbotk::OptimizerBatch$optimize()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OptimizerBatchCmaes-new"></a>}}
\if{latex}{\out{\hypertarget{method-OptimizerBatchCmaes-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OptimizerBatchCmaes$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OptimizerBatchCmaes-clone"></a>}}
\if{latex}{\out{\hypertarget{method-OptimizerBatchCmaes-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OptimizerBatchCmaes$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
