% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sumNA.R
\name{sumNA}
\alias{sumNA}
\title{Modified sum of vector elements}
\usage{
sumNA(..., na.rm = FALSE)
}
\arguments{
\item{...}{numeric or complex or logical vectors.}

\item{na.rm}{logical. Should missing values (including \code{NaN}) be removed?}
}
\value{
The sum. Returns \code{NA} if \code{x} contains only missing values 
and \code{na.rm = TRUE}.
}
\description{
The function \code{sumNA} returns the sum of all the values in its arguments.
Contrarily to \code{\link{sum}}, it returns \code{NA} instead of \code{0} when the input 
contains only missing values and missing values are removed.
}
\examples{
x <- c(NA, NA)
sum(x)
sumNA(x)
sum(x, na.rm = TRUE)
sumNA(x, na.rm = TRUE) # here is the difference

sum(c())
sumNA(c())

}
\seealso{
\code{\link{sum}}.
}

