% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkRange.R
\name{.checkRange}
\alias{.checkRange}
\title{Check Data Range -- function that checks for allowable values}
\usage{
.checkRange(df, var, varScrn = NULL, numNA = FALSE, deleteOption = "pass")
}
\arguments{
\item{df}{Data frame with data to check}

\item{var}{Variable to perform screen check on}

\item{varScrn}{Range to check (see examples)}

\item{numNA}{How to treat missing numeric values (TRUE: treat as pass,
FALSE[default]: treat as fail)}

\item{deleteOption}{Option for how to return df ("pass": return rows that
pass check, "fail": return rows that fail check, "mark": return column with
TRUE/FALSE for pass/fail)}
}
\value{
data frame modified based on user selected options. see attributes
  for screening results
}
\description{
Check Data Range -- function that checks for allowable values.
}
\examples{
# create an example data frame
df <- data.frame(
       x1 = c("X1","Y2","A1","B2","C1", "X1","","A1","","C1"),
       x2 = seq(5, 14 ) + runif(10) ,
       x3 = as.POSIXct(c("1/10/2008", "1/21/2008", "3/1/2008", "3/26/1993",
                         "11/1/2012", "6/10/2000", "8/2/1990", "7/8/2005",
                         "1/6/2008", "9/11/2008"),
                         format="\%m/\%d/\%Y"), stringsAsFactors =FALSE)
# add a few missing values
df[1,1]=NA
df[3,2]=NA
df[5,3]=NA
df

# establish allowable values for screening
x1Scrn <- as.character(c("A1", "B2", "C1", "Y2"))   # character
x2Scrn <- c(7,13)                                   # min/max value
x3Scrn <- as.POSIXct(c("1999-01-01", "2008-09-10")) # min/max date 
# (POSIXct format)

# return df with new column indicating pass [TRUE] / fail [FALSE]
.checkRange(df, var="x1", varScrn=x1Scrn, numNA=FALSE, deleteOption='mark')
.checkRange(df, var="x2", varScrn=x2Scrn, numNA=FALSE, deleteOption='mark')
.checkRange(df, var="x3", varScrn=x3Scrn, numNA=FALSE, deleteOption='mark')

# return df with only rows that pass check
.checkRange(df, var="x1", varScrn=x1Scrn, numNA=FALSE, deleteOption='pass')
.checkRange(df, var="x2", varScrn=x2Scrn, numNA=FALSE, deleteOption='pass')
.checkRange(df, var="x3", varScrn=x3Scrn, numNA=FALSE, deleteOption='pass')
}
\keyword{internal}
