% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gamTestSeason.r
\name{gamTestSeason}
\alias{gamTestSeason}
\title{Perform GAM analysis for Specified Season}
\usage{
gamTestSeason(
  df,
  dep,
  stat,
  layer = NA,
  analySpec,
  gamTable = TRUE,
  gamPlot = 10,
  gamDiffModel = c(2),
  flow.detrended = NA,
  salinity.detrended = NA,
  gamSeasonPlot = c("7/1-9/30", "purple", "range")
)
}
\arguments{
\item{df}{data frame}

\item{dep}{dependent variable}

\item{stat}{station}

\item{layer}{layer}

\item{analySpec}{analytical specifications}

\item{gamTable}{gam table setting (set to FALSE to turn off table output)}

\item{gamPlot}{gam plot setting (set to FALSE to turn off plotting)}

\item{gamDiffModel}{GAM model(s) used for computing differences on sub-annual/multi-period basis}

\item{flow.detrended}{data generated by detrended.flow.  Default = NA.}

\item{salinity.detrended}{data generated by detrended.flow.  Default = NA.}

\item{gamSeasonPlot}{Character vector for evaluating and displaying seasonal model (see details for further information).}
}
\value{
Returns a list with results
}
\description{
Perform GAM analysis for Specified Season. Relies on mgcv::gam to perform general additive model.
}
\details{
gamSeasonPlot is an additional argument (relative to the arguments used in
the gamTest function) that is used to target a specific season for the focus
of output and can be a 2- or 3-element vector. While the GAM is fit to all
data as in the function gamTest, the output figure will only show the model
corresponding to the gamSeasonPlot specifications. The first element of
gamSeasonPlot can be a single date (e.g., ‘8/28’) or a date range (e.g.,
‘7/1-9/30’). The second element specifies the color of the line to be
plotted. If a date range is specified as the first element and an optional
third element is provided as ‘range’, then the plot will show the season
minimum and maximum as well as the mean; otherwise, only the mean is plotted.
If the first element of gamSeasonPlot is a single date then observations
within a +/- 15-day window of the date are plotted; otherwise, only
observations within the date range are plotted. Estimates of difference are
computed with baytrends::gamDiff by setting the argument doy.set to either
the single date provided from gamSeasonPlot or the same doys used to compute
the season mean. The option to specify seasons that "wrap" around end of 
year, i.e., 12/1-1/30, has not been implemented.
}
\examples{
\dontrun{
# Specify parameter and station to analyze
dep        <- 'do'
stat       <- 'CB5.4'
layer      <- 'B'

# Prepare data and set up specifications for analysis
dfr <- analysisOrganizeData (dataCensored)
df        <- dfr[[1]]
analySpec <- dfr[[2]]

# Apply gamTest 
gamResult <- gamTest(df, dep, stat, layer, analySpec=analySpec)
gamPlotDisp(gamResult = gamResult, analySpec = analySpec,
            fullModel = 2, seasAvgModel = 2, seasonalModel = 2,
            diffType = "regular", obserPlot = TRUE, interventionPlot = TRUE,
            seasAvgPlot = TRUE, seasAvgConfIntPlot = FALSE,
            seasAvgSigPlot = FALSE, fullModelPlot = TRUE, seasModelPlot = TRUE,
            BaseCurrentMeanPlot = FALSE, adjustedPlot = FALSE)

# Apply gamTestSeason
gamResult2 <- gamTestSeason(df, dep, stat, layer, analySpec=analySpec,
                            gamSeasonPlot = c("7/15-8/15", "purple", "range"))
gamPlotDispSeason(gamResult = gamResult2, analySpec = analySpec,
                  fullModel = 2, seasAvgModel = 2, seasonalModel = 2,
                  diffType = "regular", obserPlot = TRUE, interventionPlot = TRUE,
                  seasAvgPlot = TRUE, seasAvgConfIntPlot = FALSE,
                  seasAvgSigPlot = FALSE, fullModelPlot = FALSE, seasModelPlot = FALSE,
                  BaseCurrentMeanPlot = TRUE, adjustedPlot = FALSE, gamSeasonFocus = TRUE)
}     
}
\seealso{
\code{\link{gamTest}}
}
