% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smwrGraphs_setGD.R, R/smwrGraphs_setPage.R
\name{setGD}
\alias{setGD}
\alias{setPage}
\alias{setPDF}
\alias{setSweave}
\alias{setGD}
\alias{setKnitr}
\alias{setPNG}
\alias{setRStudio}
\title{Graphics Page}
\usage{
setGD(name = "USGS")

setPage(layout = "portrait", font = "preview", name = "USGS",
  multiple = FALSE, device = "default")
}
\arguments{
\item{name}{the name of the graphics page or the filename for
\code{setSweave}.}

\item{layout}{A description of the orientation and shape of the graphics
page. See \bold{Details}.}

\item{font}{a description of the font. The choices are "preview," which is
12 point Arial Narrow; "USGS," which is 8 point Arial Narrow; "EST," which
is 8 point Times New Roman; "PPT," which is 24 point Arial; and "PDF," which
is 8 point Arial Helvetica-Narrow. "PDF" should be chosen if the graphs are
to be saved to a portable document format (pdf) file.}

\item{multiple}{logical, if \code{TRUE}, then allow multiple pages.}

\item{device}{the name of the graphics device. See \bold{Details}.}

\item{basename}{the base name of the pdf file name.}

\item{multiplefiles}{logical, if \code{TRUE}, then modify \code{basename}
to create multiple files for multiple pages.}

\item{height}{the height of the graphics page.}

\item{width}{the width of the graphics page.}

\item{\dots}{additional arguments, which are ignored by \code{setSweave},
\code{setKnitr}, and \code{setPNG}.}
}
\value{
For \code{setPage} and \code{setPDF}, a list with two components:
dev, the device number; and name, the name or basename. For \code{setGD}
\code{setSweave}, \code{setKnitr}, \code{setPNG}, and \code{setRStudio}
nothing is returned.
}
\description{
Sets up a graphics page. The functions \code{setPage}, \code{setRStudio}, and 
\code{setGD} set up onscreen devices. The functions \code{setPDF}, \code{setSweave},
\code{setKnitr}, and \code{setPNG} set up files for graphics output.
}
\details{
If \code{layout} is "portrait," then the page size is 8.5 by 11 inches and
the graph area is 7.25 by 9.5 inches.

If \code{layout} is "landscape," then the page size is 11 by 8.5 inches and 
the graph area is 9.5 by 7.25 inches.

If \code{layout} is "square," then the page size is 7 by 7 inches
and the graph area is 6.5 by 6.5 inches (\code{setPage} only).

If \code{layout} is "slide," then the page size is 10 by 7.5 inches and the
graph area is 9.5 by 7.0 inches (\code{setPage} only).

\code{Layout} may also be a tagged list, with components \code{width} and 
\code{height} giving the width and height of the page, the width and height
of the graph area is 0.5 inch less that the page, except for \code{setPDF} 
where it is 0.1 inch less.

The user may specify a graphics device other than the default for
the system. This may be necessary when running under certain user
environments like RStudio (TM).

Added from smwrGraphs.
}
\note{
The focus of all of the graphics functions is on producing near-publication
ready figures for U.S. Geological Survey (USGS) report series. The function \code{setPDF} 
should be used to create the PDF files for those figures. The fonts that are used in
graphs created by calling \code{setPDF} closely mimic those required in USGS reports.
One peculiarity of the fonts is that bold expressions do not appear bold in the PDF, but 
the font is tagged bold.

The functions \code{setSweave}, \code{setKnitr}, and \code{setPNG}
are graphics set up functions to be used when using \code{Sweave},
\code{knitr} and \code{markdown}, respectively. The functions 
\code{setSweave} and \code{setPDF} require a call to \code{dev.off} to 
close the graphics device after all graphics are completed; \code{knitr} 
and \code{markdown} automatically close the graphics device, so the call
to \code{dev.off} is not needed in those scripts.

The function \code{setRStudio} is designed to set up the default graphics
device in RStudio rather than open a separate graphics screen. This is useful
for preview only as some features of the graphics system cannot be replicated
on that graphics device.

The function \code{setGD} is designed to be a quick and easy
graphics page setup function. It is designed to be used by functions to set
up the graphics environment if the user fails to do so.
}
\examples{
\dontrun{
# See for examples of setGD:
demo(topic="AnnualFlowBarChart", package="smwrGraphs")
demo(topic="Coplot-complexScatterPlot", package="smwrGraphs")
demo(topic="Coplot-simpleBoxPlot", package="smwrGraphs")
demo(topic="DurationHydrograph", package="smwrGraphs")
demo(topic="FlowDur-Measurements", package="smwrGraphs")
demo(topic="HydroPrecip", package="smwrGraphs")
# See for examples of setPage:
demo(topic="PiperScript", package="smwrGraphs")
# See for examples of setPDF:
demo(topic="MeasurementRating", package="smwrGraphs")
demo(topic="PiperScript", package="smwrGraphs")
demo(topic="RightAxisExample", package="smwrGraphs")
demo(topic="TopAxisExample", package="smwrGraphs")
# See for examples of setSweave:
vignette(topic="BoxPlots", package="smwrGraphs")
vignette(topic="DateAxisFormats", package="smwrGraphs")
vignette(topic="GraphAdditions", package="smwrGraphs")
vignette(topic="GraphGallery", package="smwrGraphs")
vignette(topic="GraphSetup", package="smwrGraphs")
vignette(topic="LineScatter", package="smwrGraphs")
vignette(topic="PiperPlot", package="smwrGraphs")
vignette(topic="ProbabilityPlots", package="smwrGraphs")
}
}
\keyword{dplot}
\keyword{internal}
