% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.mcens.R
\docType{methods}
\name{as.mcens}
\alias{as.mcens}
\alias{as.mcens,mcens,missing,missing-method}
\alias{as.mcens,lcens,missing,missing-method}
\alias{as.mcens,numeric,missing,missing-method}
\alias{as.mcens,numeric,numeric,missing-method}
\alias{as.mcens,numeric,missing,numeric-method}
\alias{as.mcens,numeric,missing,integer-method}
\alias{as.mcens,numeric,missing,character-method}
\alias{as.mcens,qw,missing,missing-method}
\alias{as.mcens,character,missing,missing-method}
\title{Multiply-censored Data Conversion}
\usage{
as.mcens(lower.val, upper.val, censor.codes)

\S4method{as.mcens}{mcens,missing,missing}(lower.val, upper.val, censor.codes)

\S4method{as.mcens}{lcens,missing,missing}(lower.val, upper.val, censor.codes)

\S4method{as.mcens}{numeric,missing,missing}(lower.val, upper.val, censor.codes)

\S4method{as.mcens}{numeric,numeric,missing}(lower.val, upper.val, censor.codes)

\S4method{as.mcens}{numeric,missing,numeric}(lower.val, upper.val, censor.codes)

\S4method{as.mcens}{numeric,missing,integer}(lower.val, upper.val, censor.codes)

\S4method{as.mcens}{numeric,missing,character}(lower.val, upper.val,
  censor.codes)

\S4method{as.mcens}{qw,missing,missing}(lower.val, upper.val, censor.codes)

\S4method{as.mcens}{character,missing,missing}(lower.val, upper.val,
  censor.codes)
}
\arguments{
\item{lower.val}{The lower limit of the actual value, the special value of
\code{-Inf} or \code{NA} can be used to indicate left-censoring.
A vector of character strings is allowed when the remark code is
combined with the value; blank values are treated as missing values, any other value
is converted to a missing value with a warning. See \bold{Examples}.}

\item{upper.val}{The upper limit of the actual value, the special value of
\code{Inf} or \code{NA} can be used to indicate right-censoring.}

\item{censor.codes}{optional codes if \code{upper.val} is missing. Any
numeric value less than 0 indicates left-censored, any value greater than 0
indicates right-censored, and 0 indicates an observed value. The character
value "<" indicates left-censored, ">" indicates right-censored, any anything
else indicates an observed value.}
}
\value{
An S4 object of class "mcens." These objects are the basis for the
analysis of censored data that are not strictly left censored.
}
\description{
Converts data to a multiply-censored data (\code{mcens})
object: various methods.
}
\details{
In keeping with the logic of \code{Surv}, \code{NA} is permitted to indicate
left- or right-censored data. If both are \code{NA}, then the observation is
treated as missing.
}
\examples{
## Create one of each type of censoring, including uncensored
# the last value is missing
as.mcens(c(-Inf, 2, 2, 5, NA), c(1, 2, 3, Inf, NA))
# For combined remark and values:
as.mcens(c("<1", "1", ">3", "1", "2"))
}
\references{
Lorenz, D.L., in preparation
}
\seealso{
\code{\link[survival]{Surv}}
}
\keyword{internal}
\keyword{manip}
\keyword{methods}
