% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smwrQW_x_convert2qw.R
\name{convert2qw}
\alias{convert2qw}
\title{Water-Quality Data}
\usage{
convert2qw(data, scheme = "booker")
}
\arguments{
\item{data}{a data frame that contains limited sample information.}

\item{scheme}{a character string that describes the naming style of the variables in
\code{data} that are to be conterted to class "qw." See \bold{Details}.}
}
\value{
A data frame of the water-quality data of class "qw" organized by
sample. Column names for the water-quality constituents are generated 
automatically. Other columns are retained unchanged.
}
\description{
Converts information from discrete water-quality samples to data of class "qw."
Attempts to construct the best-fit estimates for data of class "qw" from more limited 
data sources like just remark codes and values. But will also convert data created by 
\code{as.data.frame(object of class qw, expand=TRUE)}.
}
\details{
The options for \code{scheme} are "booker," "qw," and "partial." The "booker" naming scheme
assumes that remark columns begin with "R" or "r" and the value columns begin with "P" or "p."
That scheme is the most limited form because it forces missing values or blanks for almost all other
of the meta data. The "qw" scheme assumes that the columns are named according to 
\code{as.data.frame(object of class qw, expand=TRUE)}. The "partial" scheme assumes that the basic 
scheme from \code{as.data.frame(object of class qw, expand=TRUE)} is retained, but not all 
columns are required. Variations include no suffix for the value and .dl
in lieu of .rlv for the detection limit. When .dl is used, the method detection limit is assumed 
to be "MDL" if not supplied. If the scheme is "partial," then at least the value and remark or 
detetion limit or reporting limit must be supplied.
}
\examples{
# Make a dummy partial dataset
tmp.dum <- data.frame(sta=c("A", "B"),
 Val=c(1, 1.2),
 Val.rmk=c("<", ""),
 Val.dl=c(1, 1), stringsAsFactors=FALSE)
convert2qw(tmp.dum, scheme="partial")

}
\references{
Lorenz, D.L., 2014, smwrQW OFR.\cr See information about discrete
samples at \url{https://nwis.waterdata.usgs.gov/usa/nwis/qw}.
}
\seealso{
\code{\link{readNWISqw}}, \code{\link{makeColNames}}
}
\keyword{IO}
\keyword{datasets}
\keyword{internal}
