% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smwrQW_x_Arith-censored.R
\docType{methods}
\name{Arith-censored}
\alias{Arith-censored}
\alias{Arith,lcens,numeric-method}
\alias{Arith,numeric,lcens-method}
\alias{Arith,lcens,lcens-method}
\alias{Arith,mcens,numeric-method}
\alias{Arith,numeric,mcens-method}
\alias{Arith,mcens,mcens-method}
\alias{Arith,qw,numeric-method}
\alias{Arith,numeric,qw-method}
\alias{Arith,qw,qw-method}
\title{Arithmetic Methods for \code{lcens}, \code{mcens}, and \code{qw} objects}
\usage{
\S4method{Arith}{lcens,numeric}(e1, e2)

\S4method{Arith}{numeric,lcens}(e1, e2)

\S4method{Arith}{lcens,lcens}(e1, e2)

\S4method{Arith}{mcens,numeric}(e1, e2)

\S4method{Arith}{numeric,mcens}(e1, e2)

\S4method{Arith}{mcens,mcens}(e1, e2)

\S4method{Arith}{qw,numeric}(e1, e2)

\S4method{Arith}{numeric,qw}(e1, e2)

\S4method{Arith}{qw,qw}(e1, e2)
}
\arguments{
\item{e1, e2}{numeric, censored, or water-quality data. Missing values are permitted in 
either argument and result in a missing value in the output.}
}
\value{
An object of the appropriate class for the data.
}
\description{
Some limited arithmetic methods are possible and well-defined for
censored data. Water-quality data require specialized functions to maintain data
integrity.
}
\examples{
as.lcens(c(1, 3), 2) + 1
as.lcens(c(1, 3), 2) * 2

}
\seealso{
\code{\link{add}}, \code{\link{ratio}}
}
\keyword{internal}
\keyword{manip}
\keyword{methods}
