# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Convert coded events to string events
#'
#' @param x A vector of integers
#'
#' @return A vector of strings
#' @export
#' @examples
#' CodeToEvent(c(-1:19, 21:23, 31:33, -999))
CodeToEvent <- function(x) {
    .Call(`_bayestransmission_CodeToEvent`, x)
}

#' Convert string events to coded events
#' @param x A vector of strings
#'
#' @return A vector of integers
#'
#' @export
#' @examples
#' EventToCode(c("admission", "discharge", "postest", "negtest"))
#' EventToCode(c("abxon", "abxoff", "isolon", "isoloff"))
EventToCode <- function(x) {
    .Call(`_bayestransmission_EventToCode`, x)
}

#' Get compilation flags for exposed classes
#' 
#' Returns information about which optional classes are exposed in this build.
#' This allows tests to conditionally skip tests for unexposed classes.
#' 
#' @return List with logical flags:
#'   * `comprehensive_testing` - TRUE if comprehensive testing classes are exposed
#'   * `all_classes` - TRUE if all optional classes are exposed
#'   * `minimal` - TRUE if only critical classes are exposed
#' @export
getExposureFlags <- function() {
    .Call(`_bayestransmission_getExposureFlags`)
}

#' Run Bayesian Transmission MCMC
#'
#' @param data Data frame with columns, in order: facility, unit, time, patient, and event type.
#' @param modelParameters List of model parameters, see [LogNormalModelParams()].
#' @param nsims Number of MCMC samples to collect after burn-in.
#' @param nburn Number of burn-in iterations.
#' @param outputparam Whether to output parameter values at each iteration.
#' @param outputfinal Whether to output the final model state.
#' @param verbose Print progress messages.
#'
#' @return A list with the following elements:
#'   * `Parameters` the MCMC chain of model parameters (if outputparam=TRUE)
#'   * `LogLikelihood` the log likelihood of the model at each iteration (if outputparam=TRUE)
#'   * `MCMCParameters` the MCMC parameters used
#'   * `ModelParameters` the model parameters used
#'   * `ModelName` the name of the model
#'   * `nstates` the number of states in the model
#'   * `waic1` the WAIC1 estimate
#'   * `waic2` the WAIC2 estimate
#'   * and optionally (if outputfinal=TRUE) `FinalModel` the final model state.
#' @seealso [mcmc_to_dataframe]
#' @examples
#'   # Minimal example: create parameters and run a very short MCMC
#'   params <- LinearAbxModel(nstates = 2)
#'   data(simulated.data_sorted, package = "bayestransmission")
#'   results <- runMCMC(
#'     data = simulated.data_sorted,
#'     modelParameters = params,
#'     nsims = 3,
#'     nburn = 0,
#'     outputparam = TRUE,
#'     outputfinal = FALSE,
#'     verbose = FALSE
#'   )
#'   str(results)
#' @export
runMCMC <- function(data, modelParameters, nsims, nburn = 100L, outputparam = TRUE, outputfinal = FALSE, verbose = FALSE) {
    .Call(`_bayestransmission_runMCMC`, data, modelParameters, nsims, nburn, outputparam, outputfinal, verbose)
}

#' Create a new model object
#'
#' Creates and initializes a model object based on the provided parameters.
#' This allows direct creation and inspection of model objects without running MCMC.
#' Returns a list with all model parameter values for verification.
#'
#' @param modelParameters List of model parameters, including:
#'   * `modname` Name of the model (e.g., "LogNormalModel", "LinearAbxModel", "LinearAbxModel2", "MixedModel")
#'   * `nstates` Number of states in the model
#'   * `nmetro` Number of metropolis steps
#'   * `forward` Forward parameter
#'   * `cheat` Cheat parameter
#' @param verbose Print progress messages (default: false)
#'
#' @return A list containing the initialized model parameters:
#'   * `Insitu` - In situ parameters
#'   * `SurveillanceTest` - Surveillance test parameters
#'   * `ClinicalTest` - Clinical test parameters
#'   * `OutCol` - Out of unit colonization parameters
#'   * `InCol` - In unit colonization parameters
#'   * `Abx` - Antibiotic parameters
#' @export
newModelExport <- function(modelParameters, verbose = FALSE) {
    .Call(`_bayestransmission_newModelExport`, modelParameters, verbose)
}

#' Get Individual HistoryLink Log Likelihoods (Diagnostic Function)
#'
#' This function creates a model and system history, then returns the log likelihood
#' contribution from each individual HistoryLink in the system. Useful for debugging
#' and verifying likelihood calculations.
#'
#' @param modelParameters List of model parameters (same format as runMCMC)
#' @return List containing:
#'   * `linkLogLikelihoods` - vector of log likelihoods for each link
#'   * `overallLogLikelihood` - total log likelihood from model->logLikelihood()
#'   * `numLinks` - number of history links
#' @keywords internal
#' @noRd
testHistoryLinkLogLikelihoods <- function(modelParameters) {
    .Call(`_bayestransmission_testHistoryLinkLogLikelihoods`, modelParameters)
}

#' Create a new C++ model object wrapped in appropriate reference class
#'
#' Creates and initializes a C++ model object based on the provided parameters,
#' then wraps it in the appropriate R reference class that exposes the model's
#' methods and properties.
#'
#' @param modelParameters List of model parameters (same format as runMCMC)
#' @param verbose Print progress messages (default: false)
#'
#' @return A reference class object wrapping the C++ model:
#'   * CppLogNormalModel - for "LogNormalModel"
#'   * CppLinearAbxModel - for "LinearAbxModel"
#'   * CppLinearAbxModel2 - for "LinearAbxModel2"
#'   * CppMixedModel - for "MixedModel" (note: needs Module exposure)
#'
#' The returned object provides access to model methods and properties including:
#'   * InColParams, OutColParams, InsituParams, etc.
#'   * logLikelihood(), getHistoryLinkLogLikelihoods(), etc.
#' @keywords internal
#' @noRd
newCppModelInternal <- function(modelParameters, verbose = FALSE) {
    .Call(`_bayestransmission_newCppModelInternal`, modelParameters, verbose)
}

asAbxLocationState <- function(x) {
    .Call(`_bayestransmission_asAbxLocationState`, x)
}

asMap <- function(x) {
    .Call(`_bayestransmission_asMap`, x)
}

asHistoryLink <- function(x) {
    .Call(`_bayestransmission_asHistoryLink`, x)
}

WhatAmI <- function(x) {
    .Call(`_bayestransmission_WhatAmI`, x)
}

