% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_direction.R
\name{p_direction}
\alias{p_direction}
\alias{p_direction.numeric}
\alias{p_direction.stanreg}
\alias{p_direction.brmsfit}
\alias{pd}
\title{Probability of Direction (pd)}
\usage{
p_direction(posterior, ...)

\method{p_direction}{numeric}(posterior, ...)

\method{p_direction}{stanreg}(posterior, effects = c("fixed", "random",
  "all"), parameters = NULL, ...)

\method{p_direction}{brmsfit}(posterior, effects = c("fixed", "random",
  "all"), component = c("conditional", "zi", "zero_inflated", "all"),
  parameters = NULL, ...)

pd(posterior, ...)
}
\arguments{
\item{posterior}{Vector representing a posterior distribution. Can also be a \code{stanreg} or \code{brmsfit} model.}

\item{...}{Currently not used.}

\item{effects}{Should results for fixed effects, random effects or both be returned?
Only applies to mixed models. May be abbreviated.}

\item{parameters}{Regular expression pattern that describes the parameters that
should be returned. Meta-parameters (like \code{lp__} or \code{prior_}) are
filtered by default, so only parameters that typically appear in the
\code{summary()} are returned. Use \code{parameters} to select specific parameters
for the output.}

\item{component}{Should results for all parameters, parameters for the conditional model
or the zero-inflated part of the model be returned? May be abbreviated. Only
applies to \pkg{brms}-models.}
}
\description{
Compute the \strong{Probability of Direction} (\strong{\emph{p}d}, also known as the Maximum Probability of Effect - \emph{MPE}). It varies between 50\% and 100\% and can be interpreted as the probability (expressed in percentage) that a parameter (described by its posterior distribution) is strictly positive or negative (whichever is the most probable). It is mathematically defined as the proportion of the posterior distribution that is of the median's sign. Altough differently expressed, this index is fairly similar (\emph{i.e.}, is strongly correlated) to the frequentist \strong{\emph{p}-value}.
}
\details{
\strong{Relationship with the p-value}: In most cases, it seems that the \emph{p}d corresponds to the frequentist one-sided \emph{p}-value through the formula \eqn{p_{two sided} = 2*(1-\frac{p_{d}}{100})} and to the two-sided \emph{p}-value (\emph{the most commonly reported one} through the formula \eqn{p_{one sided} = 2*(1-\frac{p_{d}}{100})}. Thus, a \code{pd} of \code{95\%}, \code{97.5\%}, \code{99.5\%} and \code{99.95\%} corresponds approximately to a\emph{p}-value of respectively \code{.1}, \code{.05}, \code{.01} and \code{.001}. See the \href{https://easystats.github.io/bayestestR/articles/guidelines.html}{\emph{reporting guidelines}}.
}
\examples{
library(bayestestR)

# Simulate a posterior distribution of mean 1 and SD 1
posterior <- rnorm(1000, mean = 1, sd = 1)
p_direction(posterior)
\dontrun{
library(rstanarm)
model <- rstanarm::stan_glm(mpg ~ wt + cyl, data = mtcars)
p_direction(model)

library(brms)
model <- brms::brm(mpg ~ wt + cyl, data = mtcars)
p_direction(model)
}

}
