% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/naive_classification_summary.R
\name{naive_classification_summary}
\alias{naive_classification_summary}
\title{Posterior Classification Summaries for a Naive Bayes model}
\usage{
naive_classification_summary(model, data, y)
}
\arguments{
\item{model}{a naiveBayes model object with categorical y}

\item{data}{data frame including the variables in the model}

\item{y}{a character string indicating the y variable in data}
}
\value{
a list
}
\description{
Given a set of observed data including a categorical response variable y 
and a naiveBayes model of y, 
this function returns summaries of the model's posterior classification quality.
These summaries include a confusion matrix as well as an estimate of the model's
overall accuracy.
}
\examples{
data(penguins_bayes, package = "bayesrules")
example_model <- e1071::naiveBayes(species ~ bill_length_mm, data = penguins_bayes)
naive_classification_summary(model = example_model, data = penguins_bayes, y = "species")
}
