% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsnip-exp_smoothing_reg.R
\name{exponential_smoothing}
\alias{exponential_smoothing}
\title{General Interface for Exponential Smoothing Models}
\usage{
exponential_smoothing(
  mode = "regression",
  seasonality = NULL,
  second_seasonality = NULL,
  seasonality_type = NULL,
  method = NULL,
  error_method = NULL
)
}
\arguments{
\item{mode}{A single character string for the type of model.
The only possible value for this model is "regression".}

\item{seasonality}{This specification of seasonality will be overridden by frequency of y,
if y is of ts or msts class. 1 by default, i.e. no seasonality.}

\item{second_seasonality}{Second seasonality.}

\item{seasonality_type}{Either "multiplicative" (default) or "generalized".
The latter seasonality generalizes additive and multiplicative seasonality types.}

\item{method}{"HW", "seasAvg", "HW_sAvg". Here, "HW" follows Holt-Winters approach.
"seasAvg" calculates level as a smoothed average of the last seasonality number of points
(or seasonality2 of them for the dual seasonality model), and HW_sAvg is an weighted
average of HW and seasAvg methods.}

\item{error_method}{Function providing size of the error. Either "std" (monotonically, but slower than proportionally,
growing with the series values) or "innov" (proportional to a smoothed abs size of innovations, i.e. surprises)}
}
\value{
A model spec
}
\description{
\code{exponential_smoothing()} is a way to generate a \emph{specification} of an ETS model
before fitting and allows the model to be created using
different packages. Currently the only package is \code{Rlgt}.
}
\details{
The data given to the function are not saved and are only used
to determine the \emph{mode} of the model. For \code{exponential_smoothing()}, the
mode will always be "regression".

The model can be created using the \code{fit()} function using the
following \emph{engines}:
\itemize{
\item "stan" (default) - Connects to \code{\link[Rlgt:rlgt]{Rlgt::rlgt()}}
}

\strong{Main Arguments}

The main arguments (tuning parameters) for the model are:
\itemize{
\item \code{seasonality}: Seasonality.
\item \code{second_seasonality}: Second seasonality.
\item \code{seasonality_type}: Either "multiplicative" (default) or "generalized".
\item \code{method}: "HW", "seasAvg", "HW_sAvg"
\item \code{error_method}:  Either "std"  or "innov"
}

These arguments are converted to their specific names at the
time that the model is fit.

Other options and argument can be
set using \code{set_engine()}.

If parameters need to be modified, \code{update()} can be used
in lieu of recreating the object from scratch.

\strong{stan (default engine)}

The engine uses \code{\link[Rlgt:rlgt]{Rlgt::rlgt()}}.

Parameter Notes:
\itemize{
\item \code{xreg} - This is supplied via the parsnip / bayesmodels \code{fit()} interface
(so don't provide this manually). See Fit Details (below).
}
}
\section{Fit Details}{


\strong{Date and Date-Time Variable}

It's a requirement to have a date or date-time variable as a predictor.
The \code{fit()} interface accepts date and date-time features and handles them internally.
\itemize{
\item \code{fit(y ~ date)}
}

\strong{Univariate (No xregs, Exogenous Regressors):}

For univariate analysis, you must include a date or date-time feature. Simply use:
\itemize{
\item Formula Interface: \code{fit(y ~ date)} will ignore xreg's.
}

\strong{Multivariate (xregs, Exogenous Regressors)}

The \code{xreg} parameter is populated using the \code{fit()} function:
\itemize{
\item Only \code{factor}, \verb{ordered factor}, and \code{numeric} data will be used as xregs.
\item Date and Date-time variables are not used as xregs
\item \code{character} data should be converted to factor.
}

\emph{Xreg Example:} Suppose you have 3 features:
\enumerate{
\item \code{y} (target)
\item \code{date} (time stamp),
\item \code{month.lbl} (labeled month as a ordered factor).
}

The \code{month.lbl} is an exogenous regressor that can be passed to the \code{expotential_smoothing()} using
\code{fit()}:
\itemize{
\item \code{fit(y ~ date + month.lbl)} will pass \code{month.lbl} on as an exogenous regressor.
}

Note that date or date-time class values are excluded from \code{xreg}.
}

\examples{
\dontrun{
library(dplyr)
library(parsnip)
library(rsample)
library(timetk)
library(modeltime)
library(bayesmodels)

# Data
m750 <- m4_monthly \%>\% filter(id == "M750")
m750

# Split Data 80/20
splits <- rsample::initial_time_split(m750, prop = 0.8)

# ---- ARIMA ----

# Model Spec
model_spec <- exponential_smoothing() \%>\%
    set_engine("stan")

# Fit Spec
model_fit <- model_spec \%>\%
    fit(log(value) ~ date + month(date), data = training(splits))
model_fit
}
}
\seealso{
\code{\link[=fit.model_spec]{fit.model_spec()}}, \code{\link[=set_engine]{set_engine()}}
}
