% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.np_glm_b.R
\name{predict.np_glm_b}
\alias{predict.np_glm_b}
\title{Predict method for lm_b model fits}
\usage{
\method{predict}{np_glm_b}(object, newdata, trials, CI_level = 0.95, ...)
}
\arguments{
\item{object}{Object of class lm_b}

\item{newdata}{An optional data.frame in which to look for variables with which
to predict.}

\item{trials}{Integer vector giving the number of trials for each
observation if family = binomial().}

\item{CI_level}{numeric. Credible interval level.}

\item{...}{optional arguments.}
}
\value{
tibble with estimate, prediction intervals, and credible intervals
for the mean.
}
\description{
Predict method for lm_b model fits
}
\examples{
\donttest{
# Generate some data
set.seed(2025)
N = 500
test_data = 
  data.frame(x1 = rnorm(N),
             x2 = rnorm(N),
             x3 = letters[1:5])
test_data$outcome = 
  rbinom(N,1,1.0 / (1.0 + exp(-(-2 + test_data$x1 + 2 * (test_data$x3 \%in\% c("d","e")) ))))

# Fit the GLM via the (non-parametric) loss-likelihood bootstrap.
fit1 <-
  np_glm_b(outcome ~ x1 + x2 + x3,
           data = test_data,
           family = binomial())
predict(fit1)
}

}
