% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poisson_test_b.R
\name{poisson_test_b}
\alias{poisson_test_b}
\title{Poisson tests}
\usage{
poisson_test_b(
  x,
  offset,
  r,
  ROPE,
  prior = "jeffreys",
  prior_shape_rate,
  CI_level = 0.95,
  plot = TRUE,
  seed = 1,
  mc_error = 0.002
)
}
\arguments{
\item{x}{Number of events.  A vector of length one or two.}

\item{offset}{Time, area, etc. measured in the Poisson process.  NOTE: Do not
take the log!}

\item{r}{optional.  If provided and inference is being made for
a single population, \code{poisson_test_b} will return the posterior
probability that the population rate is less than this value.}

\item{ROPE}{ROPE for rate ratio if inference is being made for two populations.
Provide either a single value or a vector of length two.  If the former,
the ROPE will be taken as (1/ROPE,ROPE).  If the latter, these will be
the bounds of the ROPE.}

\item{prior}{Either "jeffreys" (Gamma(1/2,0)) or "flat" (Gamma(0.001,0.001)).
This is ignored if prior_shape_rate is provided.}

\item{prior_shape_rate}{Vector of length two, giving the shape and rate parameters
for the gamma distribution that will act as the prior on the population
rates.}

\item{CI_level}{The posterior probability to be contained in the
credible intervals.}

\item{plot}{logical.  Should a plot be shown?}

\item{seed}{Always set your seed!  (Unused for a single population rate)}

\item{mc_error}{The number of posterior draws will ensure that with 99\%
probability the bounds of the credible intervals of \eqn{\lambda_1/\lambda_2}
will be within \eqn{\pm} \code{mc_error}. (Ignored for a single population
rate.)}
}
\value{
(returned invisible) A list with the following:
\itemize{
\item \code{x}, \code{offset}: data and offset(s)
\item \code{posterior_mean}, \code{posterior_mean_pop1}, \code{posterior_mean_pop2}:
posterior means of the Poisson rates
\item \code{CI}, \code{CI_pop1}, \code{CI_pop2}: Credible interval bounds for the rates
\item \code{CI_lambda1_over_lambda2}: Credible interval bounds for the rate
ratio (rate of population 1 over the rate of population 2)
\item \code{Pr_less_than_r}: (1 sample analysis only) If \code{r} was
supplied, the posterior probability that the rate is less than \code{r}.
\item \code{Pr_rate_ratio_lt_one}: (2 sample analysis only) Posterior
probability that the rate ratio is less than 1
\item \code{Pr_rateratio_in_ROPE}: (2 sample analysis only) Posterior
probability that the rate ratio is in the ROPE (based on
\code{Pr_rate_ratio_lt_one})
\item \code{rate_plot}: Posterior and prior plots for the rates
\item \code{posterior_parameters}: Posterior parameters for rates for the
gamma posterior distribution
}
}
\description{
Make inference on one or two populations using Poisson distributed count data
}
\details{
The likelihood is
\deqn{
 y \sim Poi(\lambda t),
}
where \eqn{\lambda} is the rate, and \eqn{t} is the time or area observed
and is given by the argument \code{offset}.

The prior is given by
\deqn{
 \lambda \sim \Gamma(a,b),
}
where \eqn{a} and \eqn{b} are given by the argument \code{prior_shape_rate}.
If \code{prior_shape_rate} is missing and \code{prior = "jeffreys"},
then a Jeffrey's prior will be used, i.e., \eqn{\Gamma(0.5,0)} (improper),
while if \code{prior = "flat"}, \eqn{\Gamma(0.001,0.001)} will be used.
}
\examples{
\donttest{
# One sample
poisson_test_b(x = 12)
## You can compute the posterior probability that the rate is less than r
poisson_test_b(x = 12,
               r = 8)

# Two samples
poisson_test_b(x = c(12,20))

# Offsets can be included:
poisson_test_b(x = c(12,20),
               offset = c(10,9))

# Different priors can be used
poisson_test_b(x = c(12,20),
               prior = "flat")
poisson_test_b(x = c(12,20),
               prior_shape_rate = c(20,1.5))
}


}
