% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Regression_Functions.R
\name{distreg_cfa}
\alias{distreg_cfa}
\title{Counterfactual bayesian distribution regression}
\usage{
distreg_cfa(thresh, data0, MH = "IndepMH", cft, cfIND, ...)
}
\arguments{
\item{thresh}{threshold value that is used to binarise the continuous outcome variable}

\item{data0}{original data set with the first column being the continuous outcome variable}

\item{MH}{metropolis-hastings algorithm to use; default:"IndepMH", alternative "RWMH"}

\item{cft}{column vector of counterfactual treatment}

\item{cfIND}{the column index(indices) of treatment variable(s) to replace with \code{cft} 
in \code{data0}}

\item{...}{any additional inputs to pass to the MH algorithm}
}
\value{
robj a list of a vector of fitted values corresponding to random draws from
F(yo), counterfactual F(yo), and the parameters
}
\description{
\code{distreg} draws randomly from the density of counterfactual of F(yo) at a threshold 
value yo
}
\examples{
data0=faithful[,c(2,1)]; qnt<-quantile(data0[,1],0.25)
cfIND=2 #Note: the first column is the outcome variable. 
cft=0.95*data0[,cfIND] # a decrease by 5\%
dist_cfa<- distreg_cfa(qnt,data0,cft,cfIND,MH="IndepMH",iter = 102, burn = 2)
par(mfrow=c(1,2)); plot(density(dist_cfa$counterfactual,.1),main="Original")
plot(density(dist_cfa$counterfactual,.1),main="Counterfactual"); par(mfrow=c(1,1))

}
