% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfa_fitted.R
\name{dfa_fitted}
\alias{dfa_fitted}
\title{Get the fitted values from a DFA as a data frame}
\usage{
dfa_fitted(modelfit, conf_level = 0.95, names = NULL)
}
\arguments{
\item{modelfit}{Output from \code{\link{fit_dfa}}.}

\item{conf_level}{Probability level for CI.}

\item{names}{Optional vector of names for time series labels. Should be same length as the number of time series.}
}
\value{
A data frame with the following columns: \code{ID} is an identifier for each time series, \code{time} is the time step, \code{y} is the observed values standardized to mean 0 and unit variance, \code{estimate} is the mean fitted value, \code{lower} is the lower CI, and \code{upper} is the upper CI.
}
\description{
Get the fitted values from a DFA as a data frame
}
\examples{
\donttest{
y <- sim_dfa(num_trends = 2, num_years = 20, num_ts = 4)
m <- fit_dfa(y = y$y_sim, num_trends = 2, iter = 50, chains = 1)
fitted <- dfa_fitted(m)
}
}
\seealso{
predicted plot_fitted fit_dfa
}
